package org.esupportail.portal.channels.CWebdav.tests;
   
//import java.util.Iterator;

import org.esupportail.portal.channels.CWebdav.config.Config;
import org.esupportail.portal.channels.CWebdav.exception.PropertiesException;

import junit.framework.TestCase;
   
/**     
 * @author sgaudin 
 *  
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class TestConfig extends TestCase {
	
	private Config config;
	
	 
	public static void main(String[] args) {
		junit.textui.TestRunner.run(TestConfig.class);
	}
	/*
	 * @see TestCase#setUp()
	 */  
	protected void setUp() throws Exception {
		super.setUp();
		config = new Config();
	} 
	/*   
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
		config = null;
	}
	/**  
	 * Constructor for TestConfig.
	 * @param arg0 
	 */
	public TestConfig(String arg0) {
		super(arg0);
	}   
	 
	
	/************/
	/*Le serveur*/
	/************/
	public final void testGetUrl() throws PropertiesException {
		assertEquals("http://chene.univ-rennes1.fr:8080/slide",config.getUrl());
	}
	/*public final void testGetExternText() throws PropertiesException {
		assertEquals("Acces externe",Config.getInstance().getExternText());
	}*/
	/*public final void testGetExternUrl() throws PropertiesException {
		assertEquals("http://chene.univ-rennes1.fr:8889/~{user}",Config.getInstance().getExternUrl());
	} */    

	/********************/
	/*L'authentification*/
	/********************/
	/*public final void testClassAuth() throws PropertiesException {
		assertEquals("org.esupportail.portal.channels.CWebdav.provider.AuthShareImpl",Config.getInstance().getClassAuth());
	}*/
	public final void testTrustedPassword() throws PropertiesException {
		assertEquals("xpcwd",config.getTrustedPassword());
	}
	public final void testUsernameAttribute() throws PropertiesException {
		assertEquals("username",config.getUsernameAttribute());
	}    
   
	/*******************************/
	/*La classe d'interrogation DAV*/
	/*******************************/
	public final void testClassAccess() throws PropertiesException {
		assertEquals("org.esupportail.portal.channels.CWebdav.provider.DavAccessImpl",config.getClassAccess());
	}        
	
	/****************************/
	/*Les options de l'interface*/
	/****************************/
	public final void testConfirmDel() throws PropertiesException {
		assertTrue(config.getConfirmDel());
	}	
	public final void testAllowDelNonEmptyFolder() throws PropertiesException {
		assertTrue(config.getAllowDelNonEmptyFolder());
	}
	
	/********************/
	/*La base de donnes*/
	/********************/
	/* 
	 * ajout de prefStoreTable et pool
	 * */		
	/*public final void testPrefStoreTable() throws PropertiesException {
		assertEquals("DAV_PREFS",Config.getInstance().getPrefStoreTable());
	}*/	 
	/*public final void testPool() throws PropertiesException {
		assertEquals("eSupPool",Config.getInstance().getPool());
	}*/	 
	 
	public final void testInvisibleRegexp() throws PropertiesException { 
		assertEquals("^\\..*",(String)config.getInvisibleRegexp().firstElement());

	}
	
	
}
