/**
 * Cre le 6 Mai 2004
 * Par Sbastien Gougeon
 * Centre de Ressources Informatiques
 * Universit de Rennes 1 - France
 * sebastien.gougeon@univ-rennes1.fr
 * 
 */      
/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/

package org.esupportail.portal.channels.CWebdav.tests;


import org.esupportail.portal.channels.CWebdav.provider.DavAccess;
import org.esupportail.portal.channels.CWebdav.provider.DavAccessImpl;
import org.esupportail.portal.channels.CWebdav.exception.*;

import junit.framework.TestCase;


public class TestCreate extends TestCase {

	private String name;
	private String path;
	private DavAccess dav;
	
	public static void main(String[] args) {
		junit.swingui.TestRunner.run(TestCreate.class);			
	}

	
	
	protected void setUp() throws Exception {
		super.setUp();
		
		dav = new DavAccessImpl();
		dav.init("http://chene.univ-rennes1.fr:8080/slide","bidon","xpcwd");
		dav.connect();
				
		name = "toto";
		path = "/slide/files/esup/storage/users/n/no/bidon/testCreate/SebTest/";			
	}
	
	
	
	protected void tearDown() throws Exception {
		super.tearDown();
		dav.delete(name, path);
		name = null;
		path = null;
		
		dav.disconnect();
	}

	public void testCreate() throws ApplicationException, CreateDirectoryException, StillExistsException, BadFormatException, NotAuthorizedException, NotExistsResourceException, NotAuthorizedNewDirException{
		assertTrue("verifie si le rep toto est cre dans /~bidon/testCreate/SebTest/ : ",dav.createDir(name, path));
	}
	public void testCreateIfExist() throws ApplicationException, CreateDirectoryException, StillExistsException, BadFormatException, NotAuthorizedException, NotExistsResourceException, NotAuthorizedNewDirException{
			dav.createDir(name, path);	
			try{
				dav.createDir(name, path);					
			}
			catch (StillExistsException e){
			assertEquals("verifie si le rep toto est cre dans /~bidon/testCreate/SebTest/ alors qu'il existe deja : ",1003,e.getErrorCode() );
			}
	}
}
