/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.portal.utils.webdav.acl;

public class EsupPermission
implements Comparable {
    public static final boolean GRANT = false;
    public static final boolean DENY = true;
    public static final String READ = "read";
    public static final String WRITE = "write";
    public static final String READ_ACL = "read-acl";
    public static final String WRITE_ACL = "write-acl";
    public static final String READ_CURRENT_USER_PRIVILEGE_SET = "read-current-user-privilege-set";
    public static final String WRITE_PROPERTIES = "write-properties";
    public static final String WRITE_CONTENT = "write-content";
    public static final String ALL = "all";
    public static final String PRINCIPAL_UNAUTHENTICATED = "unauthenticated";
    public static final String PRINCIPAL_ALL = "all";
    public static final String PRINCIPAL_PROPERTY = "property";
    private boolean negative;
    private String principal;
    private String permissionType;
    private boolean inherited;
    private String inheritedFrom;
    private boolean protectedPermission;
    private String namespace;
    private String userPrefix;
    private String groupPrefix;

    public EsupPermission(boolean negative, String principal, String permissionType, boolean inherited, String inheritedFrom, boolean protectedPermission, String namespace, String userPrefix, String groupPrefix) {
        this.negative = negative;
        this.principal = principal;
        this.permissionType = permissionType;
        this.inherited = inherited;
        this.inheritedFrom = inheritedFrom;
        this.protectedPermission = protectedPermission;
        this.namespace = namespace;
        this.userPrefix = userPrefix;
        this.groupPrefix = groupPrefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public String getInheritedFrom() {
        return this.inheritedFrom;
    }

    public boolean isGrantPermission() {
        return !this.negative;
    }

    public boolean isDenyPermission() {
        return this.negative;
    }

    public String getPermissionType() {
        return this.permissionType;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public boolean isProtectedPermission() {
        return this.protectedPermission;
    }

    public boolean isPrincipalUser() {
        return this.principal.startsWith(this.userPrefix);
    }

    public boolean isPrincipalGroup() {
        return this.principal.startsWith(this.groupPrefix);
    }

    public boolean isPrincipalAll() {
        return this.principal.equals("all");
    }

    public boolean isPrincipalUnauthenticated() {
        return this.principal.equals(PRINCIPAL_UNAUTHENTICATED);
    }

    public int compareTo(Object arg0) {
        EsupPermission perm = (EsupPermission)arg0;
        if (this.equals(perm)) {
            return 0;
        }
        if (this.isInherited()) {
            if (perm.isInherited()) {
                return this.compareInheritedFrom(perm);
            }
            return 1;
        }
        if (perm.isInherited()) {
            return -1;
        }
        return this.comparePrincipal(perm);
    }

    private int comparePrincipal(EsupPermission perm) {
        String thisPrincipal = this.getPrincipal();
        String permPrincipal = perm.getPrincipal();
        boolean thisIsPrincipalUser = this.isPrincipalUser();
        boolean thisIsPrincipalGroup = this.isPrincipalGroup();
        boolean thisIsPrincipalAll = this.isPrincipalAll();
        boolean thisIsPrincipalUnauthenticated = this.isPrincipalUnauthenticated();
        boolean permIsPrincipalUser = perm.isPrincipalUser();
        boolean permIsPrincipalGroup = perm.isPrincipalGroup();
        boolean permIsPrincipalAll = perm.isPrincipalAll();
        boolean permIsPrincipalUnauthenticated = perm.isPrincipalUnauthenticated();
        if (thisIsPrincipalUser) {
            if (permIsPrincipalUser) {
                int comp = thisPrincipal.compareTo(permPrincipal);
                if (comp == 0) {
                    return 1;
                }
                return comp;
            }
            if (permIsPrincipalGroup) {
                return -1;
            }
            if (permIsPrincipalAll || permIsPrincipalUnauthenticated) {
                return -1;
            }
            return -1;
        }
        if (thisIsPrincipalGroup) {
            if (permIsPrincipalUser) {
                return 1;
            }
            if (permIsPrincipalGroup) {
                int comp = -thisPrincipal.compareTo(permPrincipal);
                if (comp == 0) {
                    return 1;
                }
                return comp;
            }
            if (permIsPrincipalAll || permIsPrincipalUnauthenticated) {
                return -1;
            }
            return -1;
        }
        if (thisIsPrincipalAll) {
            if (permIsPrincipalUser) {
                return 1;
            }
            if (permIsPrincipalGroup) {
                return 1;
            }
            if (permIsPrincipalAll) {
                return 1;
            }
            if (permIsPrincipalUnauthenticated) {
                return 1;
            }
            return -1;
        }
        if (thisIsPrincipalUnauthenticated) {
            if (permIsPrincipalUser) {
                return 1;
            }
            if (permIsPrincipalGroup) {
                return 1;
            }
            if (permIsPrincipalUnauthenticated) {
                return 1;
            }
            if (permIsPrincipalAll) {
                return -1;
            }
            return -1;
        }
        if (permIsPrincipalUser) {
            return 1;
        }
        if (permIsPrincipalGroup) {
            return 1;
        }
        if (permIsPrincipalUnauthenticated) {
            return 1;
        }
        if (permIsPrincipalAll) {
            return 1;
        }
        int comp = thisPrincipal.compareTo(permPrincipal);
        if (comp == 0) {
            return 1;
        }
        return comp;
    }

    private int compareInheritedFrom(EsupPermission perm) {
        if (this.getInheritedFrom().equals(perm.getInheritedFrom())) {
            return this.comparePrincipal(perm);
        }
        return -this.getInheritedFrom().compareTo(perm.getInheritedFrom());
    }

    public boolean equals(Object arg0) {
        EsupPermission perm = (EsupPermission)arg0;
        if (this.getPrincipal().equals(perm.getPrincipal()) && this.negative == perm.negative && this.isInherited() == perm.isInherited()) {
            if (this.isInherited() && this.getInheritedFrom() != null && perm.getInheritedFrom() != null && !this.getInheritedFrom().equals(perm.getInheritedFrom())) {
                return false;
            }
            if (this.getPermissionType().equals(perm.getPermissionType()) && this.isProtectedPermission() == perm.isProtectedPermission()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String s = "";
        s = s + this.getPrincipal() + " --> ";
        if (this.isDenyPermission()) {
            s = s + "deny ";
        }
        if (this.isGrantPermission()) {
            s = s + "grant ";
        }
        s = s + this.getPermissionType() + " ";
        s = this.isProtectedPermission() ? s + "(protected) " : s + "(not protected) ";
        s = this.isInherited() ? s + "(inherited from " + this.getInheritedFrom() + ") " : s + "(not inherited) ";
        return s;
    }
}

