/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/

package org.esupportail.portal.channels.CWebdav.config;


/**
 * Id: Config.java,v 1.0<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: Config<br/>
 * Original Author: Sbastien GAUDIN<br/>
 * This class parse the CWebdav.xml config file to return all parameters<br/>
 */



import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CWebdav.exception.PropertiesException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;



public class ChannelConfiguration { 
	

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(ChannelConfiguration.class);
	
	
	
	/*spaces*/
	private ArrayList spaces = new ArrayList();	
	private Hashtable serverAccess = new Hashtable();
	private Hashtable channelActions = new Hashtable();
	

	/*Ldap access*/
	private String ldapServerUrl;
	private String ldapPeople;
	private String ldapUserKeyAttribute;
	private String ldapUserDisplayNameAttribute;

	
	/*Authentication*/
	private String usernameAttribute;

	
	/*Interface options*/
	private boolean confirmDel = true;
	private boolean allowDelNonEmptyFolder = true;
		
	/*Regular expression for "invisibles" files*/
	private Vector invisibleRegexp = new Vector();
	


	/*path of the config file*/
	private String configFilePath ="/properties/channels/org_esup/CWebdav/CWebDav.xml";
	
	
	
	/**
	 * Constructor
	 */
	public ChannelConfiguration() throws PropertiesException {

		Digester digester = new Digester();
		digester.setValidating(false);
		digester.push(this);
		
		/*
		 * The server access
		 */
		digester.addObjectCreate("CHANNEL_CONFIGURATION/SERVER_ACCESS_CLASS/ACCESS",ServerAccessClass.class);		
		
		digester.addSetProperties("CHANNEL_CONFIGURATION/SERVER_ACCESS_CLASS/ACCESS","serverType","serverType");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SERVER_ACCESS_CLASS/ACCESS","class", "accessClass");
		
		digester.addSetNext("CHANNEL_CONFIGURATION/SERVER_ACCESS_CLASS/ACCESS", "setServerAccess");
		
		

		/*
		 * The channel action
		 */
		digester.addObjectCreate("CHANNEL_CONFIGURATION/CHANNEL_ACTION_CLASS/ACTION",ChannelActionClass.class);		
		
		digester.addSetProperties("CHANNEL_CONFIGURATION/CHANNEL_ACTION_CLASS/ACTION","serverType","actionType");
		digester.addSetProperties("CHANNEL_CONFIGURATION/CHANNEL_ACTION_CLASS/ACTION","class", "actionClass");
		
		digester.addSetNext("CHANNEL_CONFIGURATION/CHANNEL_ACTION_CLASS/ACTION", "setChannelActions");
		
		
			
		
		/*
		 * The spaces
		 */
		digester.addObjectCreate("CHANNEL_CONFIGURATION/SPACES/SPACE",Space.class);		
		
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","key","key");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","label", "label");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","url", "url");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","path", "path");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","serverType", "serverType");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","actionType", "actionType");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","authenticationMode", "authenticationMode");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","trustedLogin", "trustedLogin");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","trustedPassword", "trustedPassword");		
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","aclNamespace", "namespace");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","aclUserPrefix", "userPrefix");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","aclGroupPrefix", "groupPrefix");
		
		// the authorization
		digester.addObjectCreate("CHANNEL_CONFIGURATION/SPACES/SPACE/ALLOWED",AuthorizationSpaceParameter.class);
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE/ALLOWED");		
		
		digester.addSetNext("CHANNEL_CONFIGURATION/SPACES/SPACE/ALLOWED", "setAuthorization");
		
		digester.addSetNext("CHANNEL_CONFIGURATION/SPACES/SPACE", "setSpaces");
		
		
		

		/*
		 * The ldap access
		 */		
		digester.addSetProperties("CHANNEL_CONFIGURATION/LDAP_ACCESS");
		digester.addCallMethod("CHANNEL_CONFIGURATION/LDAP_ACCESS", "setLdapServerUrl", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/LDAP_ACCESS", 0, "serverUrl");
		digester.addCallMethod("CHANNEL_CONFIGURATION/LDAP_ACCESS", "setLdapPeople", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/LDAP_ACCESS", 0, "people");
		digester.addCallMethod("CHANNEL_CONFIGURATION/LDAP_ACCESS", "setLdapUserKeyAttribute", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/LDAP_ACCESS", 0, "userKeyAttribute");
		digester.addCallMethod("CHANNEL_CONFIGURATION/LDAP_ACCESS", "setLdapUserDisplayNameAttribute", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/LDAP_ACCESS", 0, "userDisplayNameAttribute");
		

		
		

		/*
		 * The authentication
		 * Add username_attribute,trusted_password and classAuth
		 */		
		digester.addSetProperties("CHANNEL_CONFIGURATION/AUTH");
		digester.addCallMethod("CHANNEL_CONFIGURATION/AUTH", "setClassAuth", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/AUTH", 0, "class");			
		

		
		
		
		/*
		 * Interface options
		 * Add confirmDel and allowDelNonEmptyFolder
		 */		
		digester.addCallMethod("CHANNEL_CONFIGURATION/DEFAULT_OPTIONS_INTERFACE", "setConfirmDel", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/DEFAULT_OPTIONS_INTERFACE", 0, "confirmDel");
		digester.addCallMethod("CHANNEL_CONFIGURATION/DEFAULT_OPTIONS_INTERFACE", "setAllowDelNonEmptyFolder", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/DEFAULT_OPTIONS_INTERFACE", 0, "allowDelNonEmptyFolder");
		  
		/*
		 * Invisibles files
		 * Add every  regular Expression
		 */		
		digester.addCallMethod("CHANNEL_CONFIGURATION/INVISIBLE_FILES/REG_EXP", "addInvisibleRegexp", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/INVISIBLE_FILES/REG_EXP", 0, "pattern");

		digester.addSetProperties("CHANNEL_CONFIGURATION/TEXT_ACTION");
		
		
		
		URL url = ChannelConfiguration.class.getResource(configFilePath);		
		
		if (url != null) {

			InputSource inSource = new InputSource(url.toExternalForm());

			try {
				//parse config file
				digester.parse(inSource);							
			}
			catch (IOException e) {				
				log.error("ChannelConfiguration :: Unable to open config file" + configFilePath	+" "+ e.toString());
				throw new PropertiesException();
			}
			catch (SAXException e) {				
				log.error("ChannelConfiguration :: " + e.toString());
				throw new PropertiesException();
			}
		}
		else { 
			log.error("ChannelConfiguration :: "	+ configFilePath + " does not exist.\n");
			throw new PropertiesException();
		}
	}
	
	
	/**
	 * return the spaces list
	 * @return the spaces list
	 */
	public ArrayList getSpaces() throws PropertiesException {
		if (spaces.size()==0) {
			log.error("getSpaces :: there is no space set");
			throw new PropertiesException();
		}
				
		return spaces;
	}

	/**
	 * add a new space to the list
	 * @param space the space to add
	 */
	public void setSpaces(Space space) {
		
		// the server access class
		String serverType = space.getServerType();
		String serverClass = null;
		
		if (serverType!=null) {
			serverClass = (String)this.serverAccess.get(serverType);
			space.setServerAccessClass(serverClass);
		}
		
		// the channel action type
		String actionType = space.getActionType();
		String actionClass = null;
		
		if (actionType!=null) {
			actionClass = (String)this.channelActions.get(actionType);
			space.setChannelActionClass(actionClass);
		}		
		
		// add this space
		spaces.add(space);
	}
	
	
	

	/**
	 * return the server access list
	 * @return the server access list
	 */
	public Hashtable getServerAccess() throws PropertiesException {
		if (serverAccess.size()==0) {
			log.error("getServerAccess :: there is no server access set");
			throw new PropertiesException();
		}
				
		return serverAccess;
	}

	/**
	 * add a new server access to the list
	 * @param access the server access to add
	 */
	public void setServerAccess(ServerAccessClass access) {
		serverAccess.put(access.getServerType(), access.getAccessClass());
	}
	
	
	
	


	/**
	 * return the channel actions list
	 * @return the channel actions list
	 */
	public Hashtable getChannelActions() throws PropertiesException {
		if (channelActions.size()==0) {
			log.error("getChannelActions :: there is no channel action set");
			throw new PropertiesException();
		}
				
		return channelActions;
	}

	/**
	 * add a new channel action to the list
	 * @param action the channel action to add
	 */
	public void setChannelActions(ChannelActionClass action) {
		channelActions.put(action.getActionType(), action.getActionClass());
	}
		
	
	
	
	
	
	
	
	
	/**
	 * @return Returns the ldapPeople.
	 */
	public String getLdapPeople() {
		return ldapPeople;
	}
	/**
	 * @param ldapPeople The ldapPeople to set.
	 */
	public void setLdapPeople(String ldapPeople) {
		this.ldapPeople = ldapPeople;
	}
	/**
	 * @return Returns the ldapServerUrl.
	 */
	public String getLdapServerUrl() {
		return ldapServerUrl;
	}
	/**
	 * @param ldapServerUrl The ldapServerUrl to set.
	 */
	public void setLdapServerUrl(String ldapServerUrl) {
		this.ldapServerUrl = ldapServerUrl;
	}
	/**
	 * @return Returns the ldapUserDisplayNameAttribute.
	 */
	public String getLdapUserDisplayNameAttribute() {
		return ldapUserDisplayNameAttribute;
	}
	/**
	 * @param ldapUserDisplayNameAttribute The ldapUserDisplayNameAttribute to set.
	 */
	public void setLdapUserDisplayNameAttribute(
			String ldapUserDisplayNameAttribute) {
		this.ldapUserDisplayNameAttribute = ldapUserDisplayNameAttribute;
	}
	/**
	 * @return Returns the ldapUserKeyAttribute.
	 */
	public String getLdapUserKeyAttribute() {
		return ldapUserKeyAttribute;
	}
	/**
	 * @param ldapUserKeyAttribute The ldapUserKeyAttribute to set.
	 */
	public void setLdapUserKeyAttribute(String ldapUserKeyAttribute) {
		this.ldapUserKeyAttribute = ldapUserKeyAttribute;
	}
	/**
	 * @return Returns the allowDelNonEmptyFolder.
	 */
	public boolean getAllowDelNonEmptyFolder() {
		return allowDelNonEmptyFolder;
	}
	
	/**
	 * @param allowDelNonEmptyFolder The allowDelNonEmptyFolder to set.
	 */
	public void setAllowDelNonEmptyFolder(String allowDelNonEmptyFolder) {
		if (allowDelNonEmptyFolder.equals("true"))
			this.allowDelNonEmptyFolder = true;
		else 
			this.allowDelNonEmptyFolder = false;
	}
	
	
	public boolean getConfirmDel() {
		return confirmDel;
	}
	
	/**
	 * @param confirmDel The confirmDel to set.
	 */
	public void setConfirmDel(String confirmDel) {
		if (confirmDel.equals("true"))
			this.confirmDel = true;
		else 
			this.confirmDel = false;
	}
	
	
	/**
	 * @return Returns the usernameAttribute.
	 */
	public String getUsernameAttribute() throws PropertiesException {
		if (usernameAttribute==null) {
			log.error("getUsernameAttribute :: username attribute is not set");
			throw new PropertiesException();
		}
		return usernameAttribute;
	}
	
	/**
	 * @param usernameAttribute The usernameAttribute to set.
	 */
	public void setUsernameAttribute(String usernameAttribute) {
		this.usernameAttribute = usernameAttribute;
	}
	
	/**
	 * @return Returns the invisibleRexexp.
	 */
	public Vector getInvisibleRegexp() throws PropertiesException {
		if (invisibleRegexp==null) {
			log.error("getInvisibleRegexp :: invisible regexp is not set");
			throw new PropertiesException();
		}
		return this.invisibleRegexp;
	}
	
	/**
	 * @param regexp The invisibleRexexp to set.
	 */
	public void addInvisibleRegexp(String regexp) {
		this.invisibleRegexp.add(regexp);
		
	}
	
	
}
