/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CWebdav.userManagement;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.groups.EntityGroupImpl;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.services.GroupService;

/**
 * Id: Group.java,v 1.0 7 oct. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: Group
 * Original Author: Yohan Colmant
 * Represents a group for the management
 */
public class Group {


	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(Group.class);
	
	
	
	/**
	 * The displayed user name
	 */
	private String displayName;
		
	/**
	 * The group key
	 */
	private String key;
	
	
	/**
	 * This group hierarchy
	 */
	private Vector groupHierarchy;
	
	
	
	/**
	 * Constructor
	 * @param key the group key
	 * @param displayName The displayed group name
	 */
	public Group(String key, String displayName) {
		this.key = key;
		this.displayName = displayName;	
	}
	
	/**
	 * Constructor
	 * @param group this portal group value
	 */
	public Group(EntityGroupImpl group) throws GroupsException {
		this.key = group.getKey();
		this.displayName = group.getName();
		setGroupHierarchy(group);		
	}
	
	/**
	 * Constructor
	 * @param hierarchy this portal group hierarchy in this form: G1/G2/G3 where G1 is the root
	 * @throws GroupsException
	 */
	public Group(String hierarchy) throws GroupsException {
		groupHierarchy = new Vector();
		StringTokenizer strToken = new StringTokenizer(hierarchy, "/");
		String token = "";
		while (strToken.hasMoreTokens()) {
			token = strToken.nextToken();
			this.groupHierarchy.add(token);
		}
		
		this.key = token;
		this.displayName = getGroupName(key);		
	}
	
	
	
	/**
	 * Get the display name for the group key specified in parameter
	 * @param groupKey the group key
	 * @return the display name
	 * @throws GroupsException
	 */
	private String getGroupName(String groupKey) throws GroupsException {
		IEntityGroup myGroup = GroupService.findGroup(groupKey);
		if (myGroup==null) {

			// log
			if (log.isDebugEnabled()){
				log.debug("getGroupName"+" :: not existing group "+groupKey);
			}

			throw new GroupsException("not existing group "+groupKey);
		}
		return myGroup.getName();
	}
	
	
	
	
	/**
	 * Set this group hierarchy
	 * @param group the group to explore
	 * @throws GroupsException
	 */
	private void setGroupHierarchy(EntityGroupImpl group) throws GroupsException {
			
		groupHierarchy = new Vector();
				
		Iterator iter = group.getContainingGroups();
		if (iter.hasNext()) {
			EntityGroupImpl egi = (EntityGroupImpl)iter.next();
			recurGroupHierarchy(egi, groupHierarchy);
			groupHierarchy.addElement(egi.getKey());
		}
		groupHierarchy.addElement(group.getKey());
	}
	
	/**
	 * Set recursivly the group hierarchy
	 * @param igm the group member object
	 * @param v the vector we want to set
	 * @throws GroupsException
	 */
	private void recurGroupHierarchy(IGroupMember igm, Vector v) throws GroupsException {

		Iterator iter = igm.getContainingGroups();

		if(iter.hasNext()) {
			EntityGroupImpl egi = (EntityGroupImpl)iter.next();									
			recurGroupHierarchy(egi, v);			
			v.addElement(egi.getKey());			
		}
	}
	
	 
	/**
	 * Get the group display name
	 * @return Returns the displayName.
	 */
	public String getDisplayName() {
		return displayName;
	}
	
	/**
	 * Set the group display name
	 * @param displayName The displayName to set.
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}
	/**
	 * Get this group key
	 * @return Returns the key.
	 */
	public String getKey() {
		return key;
	}
	
	/**
	 * Get this group keys hierarchy from the root to the group key
	 * @return a vector construct with each hierarchy node
	 */
	public Vector getGroupHierarchy() {
		return this.groupHierarchy;
	}
	
	/**
	 * Check if this group equals the object given in parameter
	 * @param o the object to compare
	 * @return true if equals, false else
	 */
	public boolean equals(Object o) {
		Group g = (Group)o;		
		return g.getKey().equals(getKey());
	}
	
	
	/**
	 * Return a String from this group
	 * @return a String from this group
	 */
	public String toString() {
		return "Group: key="+key+" displayName="+displayName;
	}
}
