/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CWebdav.userManagement;

import java.util.Vector;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.Personne;
import org.esupportail.portal.channels.CWebdav.config.ChannelConfiguration;

/**
 * Id: User.java,v 1.0 7 oct. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: User
 * Original Author: Yohan Colmant
 * Represents a user for the management
 */
public class User {
 

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(User.class);
	
	
	
	
	/**
	 * The displayed user name
	 */
	private String displayName;
	
	/**
	 * The key
	 */
	private String key;
	
	
	
	/**
	 * Constructor
	 * @param key The key
	 * @param displayName The displayed user name
	 */
	public User(String key, String displayName) {
		this.key = key;
		this.displayName = displayName;
	}
	
	

	/**
	 * Constructor
	 * @param key The key
	 * @param config the access file config
	 */
	public User(String key, ChannelConfiguration config) {
		this.key = key;
		this.displayName = getUserName(key, config);
	}
	
	
	/**
	 * Constructor
	 * @param pers The retrieved people
	 */
	public User(Personne pers) {

		// key
		this.key = pers.getIdentifiant();
		
		// the display name
		Vector v = pers.getAttribute("displayName");		
		if (v.size()>0)
			this.displayName = (String)v.elementAt(0);
		else this.displayName = key;
	}
	
	
	/**
	 * Return the user name from a given key
	 * @param key the user key
	 * @param config the access file config
	 * @return the user name from a given key
	 */
	private String getUserName(String key, ChannelConfiguration config) {
		
		String displayName = key;
		try {
			displayName = LdapUsersManagement.getUserDisplayName(config.getLdapServerUrl(), config.getLdapPeople(), config.getLdapUserKeyAttribute(), key, config.getLdapUserDisplayNameAttribute());
		}
		catch(NamingException e) {
			log.error("getUserName"+" :: "+e);
		}
				
		return displayName;
	}
	
	
	
	/**
	 * Get this user's display name
	 * @return Returns the displayName.
	 */
	public String getDisplayName() {
		return displayName;
	}
	
	/**
	 * Set the display name
	 * @param displayName The displayName to set.
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}
	/**
	 * Get the key
	 * @return Returns the key.
	 */
	public String getKey() {
		return key;
	}
	
	
	/**
	 * Check if this user equals the object given in parameter
	 * @param o the object to compare
	 * @return true if equals, false else
	 */
	public boolean equals(Object o) {
		User u = (User)o;		
		return u.getKey().equals(getKey());
	}
	
	

	/**
	 * Return a String from this user
	 * @return a String from this user
	 */
	public String toString() {
		return "User: key="+key+" displayName="+displayName;
	}
}
