<?xml version='1.0' encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="iso-8859-1"/>

<!--<xsl:variable name="baseActionURL"><xsl:value-of select="ROOT/baseActionURL" /></xsl:variable>-->
<xsl:param name="baseActionURL"/>
<xsl:param name="downloadURL"/>  


<xsl:template name="_content">
	
	<script language="javascript">
		<![CDATA[

		function submitDirectory(directoryLink) {		
			document.goIntoDirectory.targetDirectory.value=directoryLink;
			document.goIntoDirectory.submit();
		}
		
		function submitFile(fileLink) {			
			document.downloadFile.downloadFile.value=fileLink;
			document.downloadFile.submit();
		}
		
		
		]]>
	</script>
	
		
		<table width="100%" border="0" cellspacing="0" cellpadding="0">
		<xsl:for-each select="/ROOT/CONTENT/DIRECTORY">	
			<xsl:sort select="@label"/>
			<tr> 
				<td width="1">			
					<input type="checkbox" name="listeFic" value="{@label}"/>
				</td>		
				<td width="1">
					<!-- Test la couleur du repertoire suivant l'etat -->
					
					<xsl:choose>
						<xsl:when test="@state='published'">							
							<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CWebdav/injac/folder_green_24px.gif" border="0"/></a>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="@state='rejected'">							
									<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CWebdav/injac/folder_red_24px.gif" border="0"/></a>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@state='waiting'">							
											<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CWebdav/injac/folder_orange_24px.gif" border="0"/></a>
										</xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="@state='expired'">							
													<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CWebdav/injac/folder_gray_24px.gif" border="0"/></a>
												</xsl:when>
												<xsl:otherwise>
														<xsl:choose>
															<xsl:when test="@state='space'">							
																<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CWebdav/injac/folder_blue_24px.gif" border="0"/></a>
															</xsl:when>
															<xsl:otherwise>
																<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CWebdav/folder_yellow_24px.gif" border="0"/></a>						
															</xsl:otherwise>
														</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>							
										</xsl:otherwise>
									</xsl:choose>							
								</xsl:otherwise>
							</xsl:choose>
							
						</xsl:otherwise>
					</xsl:choose>														
				
				</td>
				<td>
					&#160;<a class="uportal-navigation-channel" href="javascript:submitDirectory('{@link}');"><xsl:value-of select="@label"/></a>					
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>		
		</xsl:for-each>
	
	
		<xsl:for-each select="/ROOT/CONTENT/FILE">
			<xsl:sort select="@label"/>
			<!-- xsl:variable name="openlink"><xsl:value-of select="$downloadURL"/>?downloadFile=<xsl:value-of select="@label_download"/></xsl:variable -->
			<tr> 
				<td width="1">
					<input type="checkbox" name="listeFic" value="{@label}"/>
				</td>
				<td width="1">
					<a class="uportal-navigation-channel" href="javascript:submitFile('{@label_download}');">
						<img src="media/org/esupportail/portal/channels/CWebdav/file2_24px.gif" border="0"/>					
					</a>
				</td>
				<td>
					<!-- &#160;<a class="uportal-navigation-channel" href="{$openlink}"><xsl:value-of select="@label"/></a> -->
					&#160;<a class="uportal-navigation-channel" href="javascript:submitFile('{@label_download}');"><xsl:value-of select="@label"/></a>
				</td>
				<td class="uportal-crumbtrail">
					<xsl:value-of select="@weight"/>
				</td>
				<td class="uportal-crumbtrail">
					<xsl:value-of select="@dateLastUpdate"/>/<xsl:value-of select="@monthLastUpdate"/>/<xsl:value-of select="@yearLastUpdate"/>&#160;<xsl:value-of select="@hourLastUpdate"/>:<xsl:value-of select="@minuteLastUpdate"/>
				</td>
			</tr>
		</xsl:for-each>	
		</table>
	
</xsl:template>
</xsl:stylesheet>