/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
 
   package org.esupportail.portal.channels.CSympa ;

   import org.jasig.portal.IChannel ;
   import org.jasig.portal.ChannelStaticData ;
   import org.jasig.portal.ChannelRuntimeData ;
   import org.jasig.portal.ChannelRuntimeProperties ;
   import org.jasig.portal.PortalEvent ;
   import org.jasig.portal.PortalException ;
   import org.jasig.portal.utils.XSLT ;
   import org.jasig.portal.services.LogService ;
   import org.xml.sax.ContentHandler ;

   import fr.cru.www.sympa.wsdl.* ;
   import org.esupportail.portal.channels.CSympa.Digester.PropertiesManager ;

   import org.esupportail.portal.utils.CAS ;
   import org.esupportail.portal.utils.CASExceptions.CASGenericException ;
   
   import java.io.StringWriter ;
   import java.io.PrintWriter ; 
   import java.io.File ;

   
   /**
    * 
    * Description :<br/>
    * Application qui donne la liste des abonnements SYMPA d'un
    * utilisateur.
    * @version $Id : CSympa.java, V1.1, 03 juin 2004<br/>
    * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
    * Classe(s) : CSympa<br/>
    * @author Doriane Dusart<br/>
    */
    public class CSympa implements IChannel  {
      ChannelStaticData staticData = null ;
      ChannelRuntimeData runtimeData = null ;
   
   
      private static final String sslLocation = "CSympa.ssl" ;
   
      /*
      * Paramtres du fichier de conf
      */
      private final String _configurationFile = "/properties/channels/org_esup/CSympa/CSympa.xml" ;
      private String _defaultText = "" ;
      private int _descriptionCharacterNumber = 0 ;
      private String _serviceUrl = "" ;
      private String _image = null ;
      private PropertiesManager prop = null ;
         
      private String _ticket = "" ;   	
      private String _value = "false" ;
      private String _cookie ;
      private String[] _abonnements ;
   
       public CSympa() { 
       	// Vrification de l'existance du fichier de configuration.
         String urlConfigFile = this.getClass().getResource( _configurationFile ).getFile() ;
         File f = new File( urlConfigFile ) ;
         if ( !f.exists() ) 
         {
            LogService.log( LogService.INFO, 
               		"Le fichier de configuration pour le canal " 
               		+ this.getClass().getName() 
               		+ " n'existe pas  l'url indiquee( " 
               		+ _configurationFile + ")." ) ;
         }
         else {
            prop =  new PropertiesManager( _configurationFile ) ;
            this.staticData = new ChannelStaticData() ;
         }
       	       
      }
       
   	/**
   	* Cette mthode permet de rcuprer l'environnement d'excution 
   	* de l'environnement.
   	*/
       public ChannelRuntimeProperties getRuntimeProperties() {
         return new ChannelRuntimeProperties() ;
      }
       
 	/**
   	* Rcupre les venements extrieurs au canal.
   	* @param ev Les vnements envoys au canal.
   	*/       
       public void receiveEvent( PortalEvent ev ) {
      }
   
	/**
	* Rcupre les lments statiques du canal.<br/>
	* De plus cette mthode permet d'effectuer l'appel au WebService des diffrents<br/>
	* serveurs SYMPA pour rcuprer les abonnments de l'utilisateur du canal.
	* @param sd Les paramtres statiques du canal.
	*/
       public void setStaticData( ChannelStaticData sd ) {
       	SympaSOAP loc = null ;
       	SympaPort sp = null ;
       	StringWriter sw = null ;
       	java.io.PrintWriter pw = null ;
       	int i ;
         if( prop != null ) {
            LogService.log( LogService.DEBUG , "on entre dans setStaticData") ;
            this.staticData = sd ;
            this._image = prop.getImageUrl() ;
            this._defaultText = prop.getDefaultText() ;          
            this._descriptionCharacterNumber = prop.getDescriptionCharacterNumber() ;
            String temp = prop.getSympaKey();
            this._serviceUrl = prop.getServiceUrl(temp); 
                  
            try{
               LogService.log( LogService.DEBUG , "\n********* Recuperation du ticket**********" ) ;
               _ticket = CAS.get_pt( staticData , _serviceUrl ) ;
               LogService.log( LogService.DEBUG , "ticket = " + _ticket ) ;
               
               LogService.log( LogService.DEBUG , "\n********* Appel de login **********" ) ;
               loc = new SympaSOAPLocator() ;
               LogService.log( LogService.DEBUG , "\n*********SympaSOAP **********" ) ;
               ( (SympaSOAPLocator) loc ).setMaintainSession( true ) ;
               LogService.log( LogService.DEBUG , "\n********* SympaSOAPLocator **********" ) ;
            
               LogService.log( LogService.DEBUG , "\n********* SympaPort **********" ) ;
               sp = loc.getSympaPort( new java.net.URL( _serviceUrl ) ) ;
               
               LogService.log( LogService.DEBUG , "\n********* CAS Login **********" ) ;
               _value = sp.casLogin( _ticket ) ;              
               LogService.log( LogService.DEBUG , "\nretour login= " + _value ) ;
            
               LogService.log( LogService.DEBUG , "\n********* Appel de check_cookie **********" ) ;
               _cookie = sp.checkCookie() ;
               LogService.log( LogService.DEBUG , "\nretour check_cookie = " + _cookie + "\n" ) ;
            
               _abonnements = sp.which() ;
               LogService.log( LogService.DEBUG, "nb abonnements : " + _abonnements.length ) ;
               for ( i = 0 ; i < _abonnements.length ; i++ )
                  LogService.log( LogService.DEBUG, "\n _abonnement rcupr : " + i + " : "  + _abonnements[ i ] ) ;
            
            }
           //Leve d'exception pour la rcupration du ticket
                catch( CASGenericException exp ){
                  LogService.log( LogService.ERROR , "CGetPT::getMyPT() : " + "Exception de type generique (Generic): " + exp.getExceptionCode() + " " + exp.getMessage() ) ;
               }
            // Leve d'exception lors du contact au WebService pour la rcupation des abonnements
                catch (Exception e) {
               // Ecriture du dtail de la leve d'exception dans le fichier de Log.
                  try {
                  	 sw = new StringWriter() ;
                  
                     pw = new PrintWriter( sw ) ;
                     e.printStackTrace( pw ) ;
                     
                     LogService.log( LogService.ERROR , sw.toString() ) ;
                     pw.close() ;
                     sw.close() ;
                  } 
                    catch( Exception exec ) {}               
               }
            LogService.log( LogService.DEBUG , "on sort de setStaticData" ) ;
         }
      }
   
   	/**
   	* Rcupre l'environnement de travail du canal.
   	* @param rd L'environnement d'excution pass au canal. 
   	*/   
       public void setRuntimeData( ChannelRuntimeData rd ) {
      // process the form submissions
         this.runtimeData = rd ;      
      }
   
   	/**
   	* Cette mthode permet de gnrer les informations au format XML des<br/>
   	* diffrents abonnements d'un utilisateur sur les difrents serveurs SYMPA.
   	* 
   	* @param out de type XML
   	* @throws PortalException
   	*/
       public void renderXML( ContentHandler out ) 
       throws PortalException {
         StringWriter w = null ;
         w = new StringWriter() ;
         
         int nbAbonnement = 0 ;
         String[] unAbonnement = null ;
         XSLT xslt = null ;         
         w.write( "<?xml version='1.0'?>\n" ) ;
         w.write( "<content>\n" ) ;
         
         if ( prop != null ) {
         	
            LogService.log( LogService.DEBUG , "on entre dans renderXML" ) ;
            if( _image != null ) w.write( "<image>" + _image + "</image>" ) ;
            w.write( "<defaultText>" + _defaultText + "</defaultText>" ) ;
            w.write( "<login>" + _value + "</login>" ) ;
            w.write( "<cookie>" + _cookie + "</cookie>" ) ;
            try{
            	nbAbonnement = _abonnements.length ;
            	String [] temp;
               for( int i = 0 ; i < nbAbonnement ; i++ ) {
               	  /*unAbonnement = _abonnements[i].split( "homepage=" ) ;	               	  
             	  temp = unAbonnement[1].split("[;]");
             	  String lien = temp[0];
             	  LogService.log( LogService.DEBUG , "lien = "+lien);
             	  unAbonnement = unAbonnement[1].split("subject=");
             	  temp = unAbonnement[1].split(";listAddress=");
             	  String sujet = temp[0];
             	  LogService.log( LogService.DEBUG , "sujet = "+sujet);
             	  temp = temp[1].split(";isEditor=");
             	  String nom = temp[0];
             	  LogService.log( LogService.DEBUG , "nom = "+nom);*/
               	//unAbonnement = _abonnements[i].split("homepage=|subject=|isEditor=|isOwner=|isSubscriber=|listAddress=");
               	unAbonnement = _abonnements[i].split("page=|ject=|itor=|ner=|riber=|Address=|;");
               	int t;
		String isowner = "";
		String lien = "";
		String sujet = "";
		String nom = "";
		String iseditor = "";
		String issubscriber = "";

		for(t=0;t<unAbonnement.length;t++){
		    LogService.log( LogService.DEBUG , "unAbonnement["+t+"]= "+unAbonnement[t]);     
          	if(unAbonnement[t].equals("isOw")){               		
			isowner = unAbonnement[t+1];
		    }else if(unAbonnement[t].equals("home")){
			lien = unAbonnement[t+1];
		    }else if(unAbonnement[t].equals("sub")){
			sujet = unAbonnement[t+1];
		    }else if(unAbonnement[t].equals("list")){
			nom = unAbonnement[t+1];
		    }else if(unAbonnement[t].equals("isEd")){
			iseditor = unAbonnement[t+1];
		    }else if(unAbonnement[t].equals("isSubsc")){
			issubscriber = unAbonnement[t+1];
		    }
		}
		    
		    
               	
               	
               	
                w.write( "<liste>\n" ) ;
                w.write( "<homepage>" + lien + "</homepage>\n" ) ;
                w.write( "<listAddress>" + nom + "</listAddress>\n" ) ;
                w.write( "<subject>" ) ;
                if( _descriptionCharacterNumber == 0 ) w.write( sujet ) ;
                else w.write( sujet.substring( 0 , _descriptionCharacterNumber ) ) ;
                w.write( "</subject>\n" ) ;	
                w.write( "</liste>\n" ) ;
               }
            }
                catch(NullPointerException e){
                  w.write( "<error>" ) ;
                  w.write("ERROR_ABO");
                  w.write( "</error>\n" ) ;
               }
         
          }
         else {
            w = new StringWriter() ;
            w.write( "<error>" ) ;
            w.write("ERROR_CONF");
            w.write( "</error>\n" ) ;
            
            LogService.log( LogService.ERROR , "ERROR_CONF: Impossible de lire le fichier de configuration du canal." ) ;
            
         }
         w.write( "</content>" ) ;
         LogService.log( LogService.DEBUG , w.toString() ) ;

        
         xslt = new XSLT( this ) ;
         xslt.setXML( w.toString() ) ;
         xslt.setXSL( sslLocation , "main" , runtimeData.getBrowserInfo() ) ;
         xslt.setTarget( out ) ;
         xslt.transform() ;
      } 
         
   }
