/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
 
   package org.esupportail.portal.channels.CSympa.Digester ;

   import java.util.ArrayList ;

   /**
    * 
    * Description : Classe permettant de rcuperer les diffrentes <br/>
    * proprits pour l'affichage du canal Sympa.
    * 
    * @version $Id : PropertiesManager.java, V1.1, 17 mai 2004<br/>
    * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
    * Classe(s) : PropertiesManager<br/>
    * @author Doriane Dusart<br/>
    */
    public class PropertiesManager{
      private ArrayList urls ;
      private String defaultText ;
      private String imageUrl ;
      private String descriptionCharacterNumber ;
      private String PROPERTIES_FILE_NAME = "" ;
   		
  	/**
  	 * Construteur initiliasant les variables pour rcuprer les informations <br/>
  	 * d'initialisation du fichier de configuration.
  	 * @param file URL du fichier de configuration.
  	 */   		
       public PropertiesManager( String file ) {
       	 SympaServices sympas = null ;
       	 SympaUtils conf = null ;
       	
         this.PROPERTIES_FILE_NAME = file ;
         sympas = SympaServices.getInstance( PROPERTIES_FILE_NAME ) ;
         conf = sympas.getInfos() ;
         
         this.defaultText = conf.getDefaultText() ;
         this.imageUrl = conf.getImageUrl() ;
         this.descriptionCharacterNumber = conf.getDescriptionCharacterNumber() ;
         this.urls = conf.getUrls() ;
      }

   	/**
   	 * Cette mthode permet de connatre la texte  afficher concernant<br/>
   	 * le type d'abonnement. Par dfaut, le texte est "dans votre universit".
   	 * 
   	 * @return Une chaine de caractre contenant le texte  afficher dans le canal.
   	 */
       public String getDefaultText() {
         return this.defaultText ;	
      }
   	
   	/**
   	 * Cette mthode permet de lire l'URL de l'image  afficher dans le canal.
   	 * 
   	 * @return L'URL de l'image  afficher.
   	 */
       public String getImageUrl() {
         return this.imageUrl ;
      }
   	
   	/** Cette mthode permet de renvoyer le nombre de caractres d'une descrition<br/>
   	 *  afficher dans le canal. 
   	 * @return Le nombre de caractres  afficher. 
   	 */
       public int getDescriptionCharacterNumber() {
         return Integer.parseInt( this.descriptionCharacterNumber ) ;
      }

   	/**
   	 * Cette mthode permet de rcuprer les informations pour un serveur<br/>
   	 * SYMPA.
   	 * 
   	 * @return Un bean avec lequel on rcupre les informations du serveur.
   	 */
   	// TODO :  Methode a changer pour prendre en compte le multiserveur,
   	// TODO   pour l'instant on ne rcupre que le premier serveur  
       public SympaUrl getSympaUrlKey(String key) {
         SympaUrl conf = (SympaUrl) urls.get(0) ;	
         return conf ;		
      }
   	
   	/**
   	 * Cette mthode permet de rcuprer l'adresse de service d'un serveur<br/>
   	 * Sympa dsign par sa clef key dans le fichier de configuration.
   	 * @param key Le nom de la clef identifiant un serveur Sympa.
   	 * @return L'URL de service du serveur SYMPA demand.
   	 */
       public String getServiceUrl( String key ) {
         SympaUrl conf = getSympaUrlKey( key ) ;
         return conf.getUrl() ;
      }
   	
   	/**
   	 * Cette mthode permet de rcuprer l'adresse du serveur SYMPA dsign<br/>
   	 * par sa clef key dans le fichier de configuration.
   	 * @param key Le nom de la clef identifiant un serveur Sympa.
   	 * @return L'URL du serveur SYMPA demand.
   	 */
       public String getSympaUrl( String key ) {
         SympaUrl conf = getSympaUrlKey( key ) ;
         return conf.getSympaUrl() ;
      }
   	
   	/**
   	 * Cette mthode permet de rcuprer l'URL du fichier WSDL identifiant<br/>
   	 * un serveur SYMPA dsign par sa clef key dans le fichier de configuration.
   	 * @param key Le nom de la clef identifiant un serveur Sympa.
   	 * @return L'URL du fichier WSDL du serveur SYMPA.
   	 */
       public String getWsdlUrl( String key ) {
         SympaUrl conf = getSympaUrlKey( key ) ;
         return conf.getWsdlUrl() ;
      }
       
       public String getSympaKey() {
        SympaUrl conf = (SympaUrl) urls.get(0) ;	
        return conf.getKey() ;		
     } 
       
   }