/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
 
   package org.esupportail.portal.channels.CSympaMultiServeur.Digester;

   import org.jasig.portal.services.LogService ;
   import org.apache.commons.digester.Digester ;

/**
 * 
 * Description : Cette classe permet de parser le fichier de configuration du canal<br/>
 * SYMPA pour y rcuprer les diffrentes valeurs de celui-ci.
 * 
 * @version $Id : SympaServices.java, V1.0, 19 dc. 2003<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SympaServices<br/>
 * @author Doriane Dusart<br/>
 */
    public class SympaServices {
      private static SympaServices singleton = null ;
      private SympaUtils confs ;
   
	/** 
	 * Constructeur priv de la classe pour instanciation de celle-ci.
	 * @param fichier Le fichier de configuration du canal SYMPA.
	 */
       private SympaServices( String fichier ) {
         confs = getSympaConf( fichier ) ;
      }
   
	/**
	 * Permet de grer l'instance de la classe.
	 * @return Une instance de cette classe
	 */
       public static SympaServices getInstance( String fichier ) {
         if( singleton == null ) {
            singleton = new SympaServices( fichier ) ;
         }
         return singleton ;
      }
   
	/**
	 * Cette mthode permet de dclarer un Digester correspondant  la structure<br/>
	 * du fichier de configuration du canal.
	 * @param fichier Le fichier de configuration du canal SYMPA.
	 * @return Un bean contenant les informations du fichier de configuration.
	 */
       private SympaUtils getSympaConf( String fichier ) {
         SympaUtils infos = null ;
         Digester dig = null ;
         String path = null ;
      
         try
         {
            dig = new Digester() ;
            dig.setValidating( false ) ;
            dig.addObjectCreate( "Sympa" , "org.esupportail.portal.channels.CSympaMultiServeur.Digester.SympaUtils" ) ;
            dig.addObjectCreate( "Sympa/UrlsServices" , "org.esupportail.portal.channels.CSympaMultiServeur.Digester.SympaUrl" ) ;
         	
            dig.addBeanPropertySetter( "Sympa/UrlsServices/ServiceUrl" , "url" ) ;
            dig.addBeanPropertySetter( "Sympa/UrlsServices/WsdlUrl" , "wsdlUrl" ) ;
            dig.addBeanPropertySetter( "Sympa/UrlsServices/SympaUrl" , "sympaUrl" ) ;
            dig.addSetProperties( "Sympa/UrlsServices" , "key" , "key" ) ;
         	
            dig.addSetNext( "Sympa/UrlsServices" , "setUrls" ) ;
            dig.addBeanPropertySetter( "Sympa/DefaultText" , "defaultText" ) ;
            dig.addBeanPropertySetter( "Sympa/ImageUrl" , "imageUrl" ) ;
            dig.addBeanPropertySetter( "Sympa/DescriptionCharacterNumber" , "descriptionCharacterNumber" ) ;
            
            path = this.getClass().getResource( fichier ).getFile() ;
            path =  path.replaceAll( " " , "%20" ) ;
            infos = (SympaUtils) dig.parse( path ) ;
         
            return infos ;
         }
             catch( java.io.IOException ioe ) {
               LogService.log( LogService.ERROR , "SympaServices : ioexception : " + ioe ) ;
               return infos ;
            }
             catch( org.xml.sax.SAXException se ) {
               LogService.log( LogService.ERROR , "SympaServices : saxexception : " + se ) ;
               return infos ;
            }
             catch( Exception e ) {
               LogService.log( LogService.ERROR , "SympaServices : " ) ;
               e.printStackTrace() ;
               return infos ;
            }
      }
      
   	/**
   	 * Cette mthode permet de rcupurer les informations contenues<br/>
   	 * dans le fichier de configuration du canal.
   	 * @return Les informations formates sur forme d'un bean.
   	 */
       public SympaUtils getInfos() {
         return confs ;
      }
   }