/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
 
   package org.esupportail.portal.channels.CSympaMultiServeur.Digester;

   import java.util.ArrayList;
   import org.apache.commons.logging.Log;
   import org.apache.commons.logging.LogFactory;

	/**
    * 
    * Description : Classe permettant de rcuperer les diffrentes <br/>
    * proprits pour l'affichage du canal Sympa.
    * 
    * @version $Id : PropertiesManager.java, V1.1, 17 mai 2004<br/>
    * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
    * Classe(s) : PropertiesManager<br/>
    * @author Doriane Dusart<br/>
    */
    public class PropertiesManager{
    	/*
         * Proprit pour les logs
         */
      private static final Log log = LogFactory.getLog(PropertiesManager.class);
      private ArrayList urls ;
      private String defaultText ;
      private String imageUrl ;
      private String descriptionCharacterNumber ;
      private ArrayList listeKey;
  	  private static PropertiesManager singleton = null ;

      private String PROPERTIES_FILE_NAME = "" ;
   	/**
  	 * Construteur initiliasant les variables pour rcuprer les informations <br/>
  	 * d'initialisation du fichier de configuration.
  	 * @param file URL du fichier de configuration.
  	 */   		
       public PropertiesManager( String file ) {
       	 SympaServices sympas = null ;
       	 SympaUtils conf = null ;
       	 listeKey = new ArrayList();
         this.PROPERTIES_FILE_NAME = file ;
         sympas = SympaServices.getInstance( PROPERTIES_FILE_NAME ) ;
         conf = sympas.getInfos() ;
         log.info("resultats propertiesManager :"+conf);

         
         this.defaultText = conf.getDefaultText() ;
         this.imageUrl = conf.getImageUrl() ;
         this.descriptionCharacterNumber = conf.getDescriptionCharacterNumber() ;
         this.urls = conf.getUrls() ;
         
         
         for( int i=0 ; i < urls.size() ; i++ ) {
     		SympaUrl url = new SympaUrl() ; 
     		url = (SympaUrl) urls.get( i ) ;
     		String temp = url.getKey();
     		log.info("getSympaKey = "+temp) ;
     		listeKey.add(temp);
     	}	
         
      }
     /**
   	 * Permet de grer l'instance de la classe.
   	 * @return Une instance de cette classe
   	 */
       public static PropertiesManager getInstance( String fichier ) {
        if( singleton == null ) {
            singleton = new PropertiesManager( fichier ) ;
         }        
         return singleton ;
       } 

   	/**
   	 * Cette mthode permet de connatre la texte  afficher concernant<br/>
   	 * le type d'abonnement. Par dfaut, le texte est "dans votre universit".
   	 * 
   	 * @return Une chaine de caractre contenant le texte  afficher dans le canal.
   	 */
       public String getDefaultText() {
         return this.defaultText ;	
      }
   	
   	/**
   	 * Cette mthode permet de lire l'URL de l'image  afficher dans le canal.
   	 * 
   	 * @return L'URL de l'image  afficher.
   	 */
       public String getImageUrl() {
         return this.imageUrl ;
      }
   	
   	/** Cette mthode permet de renvoyer le nombre de caractres d'une descrition<br/>
   	 *  afficher dans le canal. 
   	 * @return Le nombre de caractres  afficher. 
   	 */
       public int getDescriptionCharacterNumber() {
         return Integer.parseInt( this.descriptionCharacterNumber ) ;
      }

   	/**
   	 * Cette mthode permet de rcuprer les informations pour un serveur<br/>
   	 * SYMPA.
   	 * 
   	 * @return Un bean avec lequel on rcupre les informations du serveur.
   	 */
      public SympaUrl getSympaUrlKey(String key) {
      	 int i = getIndexKey(key);
         SympaUrl conf = (SympaUrl) urls.get(i) ;	
         return conf ;		
      }
   	
   	/**
   	 * Cette mthode permet de rcuprer l'adresse de service d'un serveur<br/>
   	 * Sympa dsign par sa clef key dans le fichier de configuration.
   	 * @param key Le nom de la clef identifiant un serveur Sympa.
   	 * @return L'URL de service du serveur SYMPA demand.
   	 */
       public String getServiceUrl( String key ) {
         SympaUrl conf = getSympaUrlKey( key ) ;
         return conf.getUrl() ;
      }
   	
   	/**
   	 * Cette mthode permet de rcuprer l'adresse du serveur SYMPA dsign<br/>
   	 * par sa clef key dans le fichier de configuration.
   	 * @param key Le nom de la clef identifiant un serveur Sympa.
   	 * @return L'URL du serveur SYMPA demand.
   	 */
       public String getSympaUrl( String key ) {
         SympaUrl conf = getSympaUrlKey( key ) ;
         return conf.getSympaUrl() ;
      }
   	
   	/**
   	 * Cette mthode permet de rcuprer l'URL du fichier WSDL identifiant<br/>
   	 * un serveur SYMPA dsign par sa clef key dans le fichier de configuration.
   	 * @param key Le nom de la clef identifiant un serveur Sympa.
   	 * @return L'URL du fichier WSDL du serveur SYMPA.
   	 */
       public String getWsdlUrl( String key ) {
         SympaUrl conf = getSympaUrlKey( key ) ;
         return conf.getWsdlUrl() ;
      }
       
   	/**
   	 * Cette mthode permet de rcuprer l'URL de l'espace de stockage <br/>
   	 * du serveur SYMPA dsign par sa clef key dans le fichier de configuration.
   	 * @param key Le nom de la clef identifiant un serveur Sympa.
   	 * @return L'URL de l'espace de stockage du serveur SYMPA.
   	 */
       public String getDocumentUrl( String key ) {
         SympaUrl conf = getSympaUrlKey( key ) ;
         return conf.getDocumentUrl() ;
      }
    	/**
   	 * Cette mthode permet de choisir quel lien sera attache au nom de la liste,
	 * celui de la liste ou de son espace de stockage<br/>
    	 * @param key Le nom de la clef identifiant un serveur Sympa.
   	 * @return Le choix du lien.
   	 */
       public String getListAddressLink( String key ) {
         SympaUrl conf = getSympaUrlKey( key ) ;
         return conf.getListAddressLink() ;
      }
       
       public ArrayList getSympaKey() {
 //        	int i;
//        	for(  i=0 ; i < urls.size() ; i++ ) {
//        		SympaUrl url = new SympaUrl() ; 
//        		url = (SympaUrl) urls.get( i ) ;
//        		String temp = url.getKey();
//        		log.info("getSympaKey = "+temp) ;
//        		listeKey.add(temp);
//        	}	       	
 		log.info("listeKey.size = " + listeKey.size());
       return  listeKey;		
       }
       
       private int getIndexKey(String key){
       		int i;
       		i = listeKey.indexOf(key);       		
       		return i;
       }
       
       
       
   }
