/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */

package org.esupportail.portal.channels.CSympaMultiServeur;

import java.io.StringWriter;
import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CSympaMultiServeur.Digester.PropertiesManager;
import org.esupportail.portal.utils.CAS;
import org.esupportail.portal.utils.CASExceptions.CASGenericException;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IChannel;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;

/**
 * 
 * Description : <br/>Application qui donne la liste des abonnements SYMPA d'un
 * utilisateur. List subscriptions Sympa
 * 
 * @version $Id : CSympaMultiServeur.java, V1.2, 04 fevrier 2005 <br/>Copyright
 *          (c) 2004 Esup Portail (www.esup-portail.org) <br/>Classe(s) :
 *          CSympaMultiServeur <br/>
 * @author Doriane Dusart <br/>
 */
public class CSympaMultiServeur implements IChannel {
	/*
	 * Proprit pour les logs
	 */
	private static final Log log = LogFactory.getLog(CSympaMultiServeur.class);

	ChannelStaticData staticData = null;

	ChannelRuntimeData runtimeData = null;

	private static final String sslLocation = "CSympaMultiServeur.ssl";

	/*
	 * Paramtres du fichier de conf
	 */
	private final String _configurationFile = "/properties/channels/org_esup/CSympaMultiServeur/CSympaMultiServeur.xml";

	private String _defaultText = "";

	private int _descriptionCharacterNumber = 0;

	private String _serviceUrl = "";

	private String _image = null;

	private String _ticket = "";

	private ArrayList _allListes;

	/**
	 * Cette mthode permet de rcuprer l'environnement d'excution
	 *  
	 */
	public ChannelRuntimeProperties getRuntimeProperties() {
		return new ChannelRuntimeProperties();
	}

	/**
	 * Rcupre les venements extrieurs au canal.
	 * 
	 * @param ev
	 *            Les vnements envoys au canal.
	 */
	public void receiveEvent(PortalEvent ev) {
	}

	/**
	 * Rcupre les lments statiques du canal. <br/>De plus cette mthode
	 * permet d'effectuer l'appel au WebService des diffrents <br/>serveurs
	 * SYMPA pour rcuprer les abonnments de l'utilisateur du canal.
	 * 
	 * @param sd
	 *            Les paramtres statiques du canal.
	 * 
	 * This method allows to call the webservices of the different Sympa servers
	 * to recover the user's list subscriptions.
	 */
	public void setStaticData(ChannelStaticData sd) {
		this.staticData = sd;

		log.debug("on entre dans setStaticData");
		PropertiesManager prop = PropertiesManager.getInstance(_configurationFile);
		this._image = prop.getImageUrl();
		this._defaultText = prop.getDefaultText();
		this._descriptionCharacterNumber = prop.getDescriptionCharacterNumber();

		ArrayList listekey = prop.getSympaKey();
		log.debug("listekey.size = " + listekey.size());
		
			_allListes = new ArrayList();
		for (int i = 0; i < listekey.size(); i++) {
			log.debug("listekey = " + listekey.get(i));
			String[] _abonnements = new String[50];

			String temp = (String) listekey.get(i);
			log.debug("pour i = " + i + " temp = " + temp);
			this._serviceUrl = prop.getServiceUrl(temp);
			log.debug(" _serviceUrl = " + _serviceUrl);

			try {
				SoapConnection connexion = new SoapConnection();

				log.debug("\n********* Recuperation du ticket**********");
				_ticket = CAS.get_pt(staticData, _serviceUrl);
				log.debug("ticket = " + _ticket);
				
				/*
				 * recuperation des abonnements pour une connexion via email
				 * Utilis pour les tests depuis une machine ne possedant pas
				 * de certificat du cru
				 */
				//String login = "";
				//String password = "";
				//_abonnements = connexion.getAbonnementEmail(this._serviceUrl,login,password);
				
				/*
				 * recuperation des abonnements pour une connexion via cas
				 */
				_abonnements = connexion.getAbonnementCas(this._serviceUrl,_ticket);
				
				
				if (_abonnements != null) {
					this._allListes.add(_abonnements);
				}
				log.debug("allListes taille : " + this._allListes.size());
			}
			//Leve d'exception pour la rcupration du ticket
			catch (CASGenericException exp) {
				log.error("CGetPT::getMyPT() : "
						+ "Exception de type generique (Generic): "
						+ exp.getExceptionCode() + " " + exp.getMessage());
			}
		}
		log.debug("on sort de setStaticData");
	}

	/**
	 * Rcupre l'environnement de travail du canal.
	 * 
	 * @param rd
	 *            L'environnement d'excution pass au canal.
	 */
	public void setRuntimeData(ChannelRuntimeData rd) {
		// process the form submissions
		this.runtimeData = rd;
	}

	/**
	 * Cette mthode permet de gnrer les informations au format XML des
	 * <br/>diffrents abonnements d'un utilisateur sur les difrents serveurs
	 * SYMPA.
	 * 
	 * @param out
	 *            de type XML
	 * @throws PortalException
	 * 
	 * This method makes it possible to generate information with XML format of
	 * various user's subscriptions on the different Sympa servers
	 * 
	 *  
	 */
	public void renderXML(ContentHandler out) throws PortalException {
		StringWriter w = null;
		w = new StringWriter();

		int nbAbonnement = 0;
		String[] unAbonnement = null;
		XSLT xslt = null;
		w.write("<?xml version='1.0'?>\n");
		w.write("<content>\n");

			log.debug("on entre dans renderXML");
			if (_image != null)
				w.write("<image>" + _image + "</image>");
			w.write("<defaultText>" + _defaultText + "</defaultText>");
			try {
				for (int j = 0; j < this._allListes.size(); j++) {
					log.debug("j: " + j);
					String[] _abonnements;
					_abonnements = (String[]) this._allListes.get(j);
					log.debug("_abonnements: " + _abonnements);
					nbAbonnement = _abonnements.length;
					String[] temp;
					for (int i = 0; i < nbAbonnement; i++) {
						// unAbonnement = _abonnements[i].split( "[=;]" ) ;
						unAbonnement = _abonnements[i].split("homepage=");
						temp = unAbonnement[1].split("[;]");
						String lien = temp[0];
						log.debug("lien = " + lien);
						unAbonnement = unAbonnement[1].split("subject=");
						temp = unAbonnement[1].split(";listAddress=");
						String sujet = temp[0];
						log.debug("sujet = " + sujet);
						temp = temp[1].split(";isEditor=");
						String nom = temp[0];
						log.debug("nom = " + nom);
						w.write("<liste>\n");
						w.write("<homepage>" + lien + "</homepage>\n");
						w.write("<listAddress>" + nom + "</listAddress>\n");
						w.write("<subject>");
						if (_descriptionCharacterNumber == 0)
							w.write(sujet);
						else
							w.write(sujet.substring(0,_descriptionCharacterNumber));
						w.write("</subject>\n");
						w.write("</liste>\n");

					}
				}
			} catch (NullPointerException e) {
				w.write("<error>");
				w.write("ERROR_ABO");
				w.write("</error>\n");
			}
		
		w.write("</content>");
		log.debug(w.toString());

		xslt = new XSLT(this);
		xslt.setXML(w.toString());
		xslt.setXSL(sslLocation, "main", runtimeData.getBrowserInfo());
		xslt.setTarget(out);
		xslt.transform();
	}

}