/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
package org.esupportail.portal.channels.CSympaMultiServeur;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.services.sympa.SympaPort_PortType;
import org.esupportail.portal.services.sympa.SympaSOAP;
import org.esupportail.portal.services.sympa.SympaSOAPLocator;


/**
 * Description :<br/>
 * 
 * @version $Id : SoapConnection.java, V1.0, 11 avr. 2005<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SoapConnection.java<br/>
 */
public class SoapConnection {
	/*
     * Proprit pour les logs
     */
  private static final Log log = LogFactory.getLog(SoapConnection.class);
  
  private SympaPort_PortType _sympaport;
  private SympaSOAP _locator;
  
  public SoapConnection(){
  	getConnection();
  }
  
  
  public void getConnection(){
  	try {
  		_locator = new SympaSOAPLocator();
  		((SympaSOAPLocator) _locator).setMaintainSession(true);
  	}
  	catch(Exception e){
  		log.error("Sympa : Une erreur est survenue lors de la connexion au service"+e);
  	}
  }
  
  public String[] getAbonnementCas(String soapurl, String ticket){
  	_sympaport = getSympaPort(soapurl);
  	String temp = getCasLogin(ticket);
  	String temp2 = getCookie();
  	return getAbonnement();  	
  }
  
  public String[] getAbonnementEmail(String soapurl, String email, String password){
 	_sympaport = getSympaPort(soapurl);
  	String temp = getEmailLogin(email, password);
  	String temp2 = getCookie();
  	return getAbonnement();  	 	
  }
  
  
  
  private SympaPort_PortType getSympaPort(String soapurl){
  	log.debug("\n********* Recuperation du SympaPort **********");
 	SympaPort_PortType sp = null;
	try {
		sp = _locator.getSympaPort(new java.net.URL(soapurl));
	} 
	catch (MalformedURLException e) {
  		log.error("Sympa : Erreur lors de la connexion a l'url de sympa, erreur dans l'url : "+e);
	}
	catch(ServiceException se){
		log.error("Sympa : Erreur lors de la connexion a l'url de sympa, erreur d'invocation du service : "+se);
	}
	return sp;	
  }
  
  private String getCasLogin(String ticket){
  	log.debug("\n********* Login CAS **********");
  	try{
  		return _sympaport.casLogin(ticket);
  	}
  	catch (RemoteException re){
  		log.error("Sympa : Erreur lors du login ca : "+re);
  		return "false";
  	}
  }
  
  private String getEmailLogin(String email, String password){
  	log.debug("\n********* Login Email**********");
  	try {
		return _sympaport.login(email,password);
	} catch (RemoteException e) {
		log.error("Sympa : Erreur lors du login via email/password : "+e);
  		return null;
	}
  }
  private String getCookie(){
  	log.debug("\n********* Appel de check_cookie **********");
  	try{
  		return _sympaport.checkCookie();
  	}
  	catch (RemoteException re){
  		log.error("Sympa : Erreur lors du retour du cookie de session : "+re);
  		return null;
  	}
  }
  
  private String[] getAbonnement(){
  	log.debug("\n********* Recuperation des abonnements **********");
  	try{
  		return _sympaport.which();
  	}
  	catch(RemoteException re){
  		log.error("Sympa : Erreur de la recuperation des abonnements : "+re);
  		return null;
  	}
  }
  
  
  
  
  

}
