/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
 
   package org.esupportail.portal.channels.CSympaMultiServeur.Digester;

   import java.util.ArrayList ;

/**
 * 
 * Description :<br/>
 * Classe qui permet de stocker toutes les informations du fichier de configuration.
 * <br/>
 * @version $Id : SympaUtils.java, V1.2, 16 janv. 2006<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SympaUtils<br/>
 * @author Doriane Dusart<br/>
 */
    public class SympaUtils{
      private ArrayList urls = new ArrayList() ;
      private ArrayList testMail = new ArrayList() ;
      private ArrayList sendMail = new ArrayList();
      private String defaultText ;
      private String imageUrl ;
      private String descriptionCharacterNumber ;
      private String display;
   


	public SympaUtils() {
      }
   
   	/**
   	 * @return Returns the defaultText.
   	 */
       public String getDefaultText() {
         return defaultText ;
      }
   	/**
   	 * @param defaultText The defaultText to set.
   	 */
       public void setDefaultText(String defaultText) {
         this.defaultText = defaultText ;
      }
       
   	/**
   	 * @return Returns the descriptionCharacterNumber.
   	 */
       public String getDescriptionCharacterNumber() {
         return descriptionCharacterNumber;
      }
   	/**
   	 * @param descriptionCharacterNumber The descriptionCharacterNumber to set.
   	 */
       public void setDescriptionCharacterNumber(String descriptionCharacterNumber) {
         this.descriptionCharacterNumber = descriptionCharacterNumber;
      }
       
   	/**
   	 * @return Returns the imageUrl.
   	 */
       public String getImageUrl() {
         return imageUrl;
      }
   	/**
   	 * @param imageUrl The imageUrl to set.
   	 */
       public void setImageUrl(String imageUrl) {
         this.imageUrl = imageUrl;
      }
       
   	/**
   	 * @return Returns the urls.
   	 */
       public ArrayList getUrls() {
         return urls;
      }
   	/**
   	 * @param urls The urls to set.
   	 */
       public void setUrls(ArrayList urls) {
         this.urls = urls;
      }   
       
	/**
	 * @param url Une url de serveur SYMPA.
	 */
       public void setUrls(SympaUrl url) {
       	 urls.add(url);
       }
          
   	/**
   	 * @return Returns the testMail.
   	 */
   	public ArrayList getTestMail() {
   		return testMail;
   	}

   	/**
   	 * @param testMail The testMail to set.
   	 */
   	public void setTestMail(ArrayList testMail) {
   		this.testMail = testMail;
   	}   
	/**
	 * @param testMail param de connexion test
	 * au serveur SYMPA.
	 */

   	public void setTestMail(SympaTest testMail) {
   		this.testMail.add(testMail);
   	}   

	public ArrayList getSendMail() {
		return sendMail;
	}

	public void setSendMail(ArrayList sendMail) {
		this.sendMail = sendMail;
	}

	public void setSendMail(SympaMail sendMail) {
		this.sendMail.add(sendMail);
	}
  	
   	public String getDisplay() {
    	return display;
       }

       public void setDisplay(String display) {
       		this.display = display;
       	}

   	   	
   public String toString() {
     String s = "" ;
     ArrayList urls = getUrls() ;
     for( int i=0 ; i < urls.size() ; i++ ) {
        SympaUrl url = new SympaUrl() ; 
        url = (SympaUrl) urls.get( i ) ;			
        s += " Pour la clef : " + url.getKey() + "\n" ;
        s += "url " + i + " : " + url.getUrl() + "\n" ;
        s += "WsdlUrl : " + url.getWsdlUrl() + "\n" ;
        s += "SympaUrl : " + url.getSympaUrl() + "\n" ;
     }		
     s += "\ndefaultText : " + getDefaultText() ;
     s += "\nDescriptionCharacterNumber : " + getDescriptionCharacterNumber() ;
     s += "\nImageUrl : " + getImageUrl() ;
     s += "\nDisplay : " + getDisplay() ;
     
     SympaTest tests = (SympaTest)getTestMail().get(0);       
     s+= "Valeur de test : " + tests.getValue();
     s+= "Email = "+tests.getEmail();
     s+= "Password = "+tests.getPassword();
     return s ;
  }

   }


