/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
package org.esupportail.portal.channels.CSympaMultiServeur.Exception;
/**
 * 
 * Description : Exception levee lorsqu'une erreur s'est produite, 
 * si l'envoie de mail est active et qu'il y a une exception lors
 * de cet envoie. Cette exception est levee et expliquee dans le fichier
 * de log, puisque le mail ne peut etre envoye<br/>
 * 
 * @version $Id : PropertiesException.java, V1.0, 16 janv. 2006<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : PropertiesException<br/>
 * @author: Dusart Doriane<br/>
 * Exception called when error in the config file<br/>

 */
public class PropertiesMailException extends ChannelException {
	 /**
     * Constructor
     */
    public PropertiesMailException() {
            super("Le fichier de configuration a ete mal renseigne pour" +
					" l'envoie de mail. La valeur de l'attribut de Mail doit tre yes ou no" +
					"Par defaut il sera donc positionne a no, et aucun mail de leve d'exception" +
					"ne sera envoye" ,6);
    }

}
