/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
package org.esupportail.portal.channels.CSympaMultiServeur;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CMailTo.Mail.Mail;
import org.esupportail.portal.channels.CMailTo.MailExceptions.MalFormedMailException;
import org.esupportail.portal.channels.CSympaMultiServeur.Digester.PropertiesManager;
import org.esupportail.portal.channels.CSympaMultiServeur.Exception.PropertiesMailException;
/**
 * 
 * Description : Classe d'envoie de mail, utilisee eventuellement pour la remonte
 * d'erreur. Uitilise le canal CMailto<br/>
 * 
 * @version $Id : SendMail.java, V1.0, 16 janv. 2006<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SendMail<br/>
 * @author : Dusart Doriane
 */
public class SendMail {
   	/**
     * Proprit pour les logs
     */
  private static final Log log = LogFactory.getLog(org.esupportail.portal.channels.CSympaMultiServeur.CSympaMultiServeur.class);
	private static SendMail singleton;
	private static boolean _sendMail ;
	private static String email;
	private static String to;

	public SendMail(){
	}
	/**
   	 * Permet de grer l'instance de la classe.
   	 * @return Une instance de cette classe
   	 */
       public static SendMail getInstance() {
        if( singleton == null ) {
        	singleton = new SendMail() ;        
        }
        return singleton ;
       }
       
	   	public boolean is_sendMail() {
			return _sendMail;
		}
	   	
		public static void set_sendMail(boolean mail) {
			_sendMail = mail;
		}
	   	
		public static void setTo(String to) {
			SendMail.to = to;
		}

		public static void setFrom(String email) {
			SendMail.email = email;
			
		}
/**
 * Methode permettant d'envoyer un mail a l'adresse donne dans le fichier de
 * configuration, avec pour expediteur le mail de l'utilisateur qui a leve l'exception
 * Utilise la classe Mail du canal MailTo
 * @param message
 * @param errorCode
 */
		public void envoieMail(String message, int errorCode){
			Mail myMail = new Mail();
			myMail.setFrom(email);
			myMail.setTo(to);
			myMail.setSubject("erreur sur le canal Sympa");
			myMail.setContent("message envoy automatiquement suite a la levee de l'exception suivante: " +
					message+" code erreur : "+errorCode+".\n" +
							"Liste des codes erreur:" +
							"1 - PropertiesException" +
							"2 - AbonnementException" +
							"4 - ConnexionException" +
							"5 - PortException" +
							"6 - PropertiesMailException");
			try {
				myMail.send();
			} 
			catch (MalFormedMailException e) {
				log.error("Error when try to send mail : "+e);
			}
			
		}


}

