/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
package org.esupportail.portal.channels.CSympaMultiServeur;

import java.net.MalformedURLException;
import java.rmi.RemoteException;

import javax.xml.rpc.ServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CSympaMultiServeur.Exception.ConnexionException;
import org.esupportail.portal.channels.CSympaMultiServeur.Exception.PortException;
import org.esupportail.portal.channels.CSympaMultiServeur.services.sympa.SympaPort_PortType;
import org.esupportail.portal.channels.CSympaMultiServeur.services.sympa.SympaSOAP;
import org.esupportail.portal.channels.CSympaMultiServeur.services.sympa.SympaSOAPLocator;


/**
 * Description : Classe gerant les connexions au service SOAP de sympa<br/>
 * 
 * @version $Id : SoapConnection.java, V1.0, 11 avr. 2005<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SoapConnection.java<br/>
 */
public class SoapConnection {
	/*
     * Proprit pour les logs
     */
  private static final Log log = LogFactory.getLog(CSympaMultiServeur.class);
  
  private SympaPort_PortType _sympaport;
  private SympaSOAP _locator;
  
  public SoapConnection() throws ConnexionException{
  	getConnection();
  }
  
  
  public void getConnection() throws ConnexionException{
	  try {
		  _locator = (SympaSOAP) new SympaSOAPLocator();	  
		  ((SympaSOAPLocator) _locator).setMaintainSession(true);
	  }
	  catch(Exception e){
		  throw new ConnexionException("Une erreur est survenue lors de la connexion au service : "+e.getMessage());		  
	  }

  }
  
  public String[] getAbonnementCas(String soapurl, String ticket)  throws PortException{
  	_sympaport = getSympaPort(soapurl);
  	String temp = getCasLogin(ticket);
  	String temp2 = getCookie();
  	return getAbonnement();  	
  }
  
  public String[] getAbonnementEmail(String soapurl, String email, String password)  throws PortException{
 	_sympaport = getSympaPort(soapurl);
  	String temp = getEmailLogin(email, password);
  	String temp2 = getCookie();
  	return getAbonnement();  	 	
  }
  
  
  
  private SympaPort_PortType getSympaPort(String soapurl)throws PortException{
  	log.debug("\n********* Recuperation du SympaPort **********");
 	SympaPort_PortType sp = null;
	try {
		sp = _locator.getSympaPort(new java.net.URL(soapurl));
	} 
	catch (MalformedURLException e) {
  		throw new PortException("Erreur lors de la connexion a l'url de sympa, erreur dans l'url : "+e.getMessage());
	}
	catch(ServiceException se){
		throw new PortException("Erreur lors de la connexion a l'url de sympa, erreur d'invocation du service : "+se.getMessage());
	}
	return sp;	
  }
  
  private String getCasLogin(String ticket)throws PortException{
  	log.debug("\n********* Login CAS **********");
  	try{
  		return _sympaport.casLogin(ticket);
  	}
  	catch (RemoteException re){
   		throw new PortException("Erreur lors du login ca : "+re.getMessage());
   	}
  }
  
  private String getEmailLogin(String email, String password)throws PortException{
  	log.debug("\n********* Login Email**********");
  	try {
		return _sympaport.login(email,password);
	} catch (RemoteException e) {
		throw new PortException("Erreur lors du login via email/password : "+e.getMessage());
 	}
  }
  private String getCookie()throws PortException{
  	log.debug("\n********* Appel de check_cookie **********");
  	try{
  		return _sympaport.checkCookie();
  	}
  	catch (RemoteException re){
  		throw new PortException("Erreur lors du retour du cookie de session : "+re.getMessage());
  	}
  }
  
  private String[] getAbonnement()throws PortException{
  	log.debug("\n********* Recuperation des abonnements **********");
  	try{
  		return _sympaport.which();
  	}
  	catch(RemoteException re){
  		throw new PortException("Erreur de la recuperation des abonnements : "+re.getMessage());
  	}
  }
  
  
  
  
  

}
