/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
package org.esupportail.portal.channels.CSympaMultiServeur;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 * 
 * Description : traitement de la chaine de caracteres renvoyee par le service soap.
 * Elle est differente selon la version de sympa utilisee<br/>
 * 
 * @version $Id : TraitementAbonnement.java, V1.0, 16 janv. 2006<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : TraitementAbonnement<br/>
 * @author : Dusart Doriane
 */


public class TraitementAbonnement {
	/*
	 * Proprit pour les logs
	 */
	private static final Log log = LogFactory.getLog(CSympaMultiServeur.class);

	private ArrayList _allListes;
	private String[] _abonnements;
	private int nbAbonnement;
	private int _descriptionCharacterNumber;
	
	/**
	 * @param allListes
	 */
	public TraitementAbonnement(ArrayList allListes, int descriptionCharacterNumber) {
		this._allListes = allListes;
		this._descriptionCharacterNumber = descriptionCharacterNumber;
	}

	/*
	 * TODO
	 * voir si on ne peut pas recuperer de facon generique les informations plutot que 
	 * de s'occuper de l'ordre d'arrivee
	 * Sinon, crer une interface et l'implementer pour chaque version de sympa
	 * plutt que d'ajouter une methode
	 */

	public String Traitement(){
		String w = new String();		
		for (int j = 0; j < _allListes.size(); j++) {
			log.debug("j: " + j);
			_abonnements = (String[]) _allListes.get(j);
			log.debug("_abonnements: " + _abonnements);
			nbAbonnement = _abonnements.length;
			for (int i = 0; i < nbAbonnement; i++) {
				Liste liste = new Liste();
				log.debug("i= "+i);
				log.info("abonnement = "+_abonnements[i]);
				log.debug("index de listadress = "+_abonnements[i].indexOf(";listAdress="));
				log.debug("index de subject = "+_abonnements[i].indexOf(";subject="));
				if(_abonnements[i].indexOf(";listAddress=") > _abonnements[i].indexOf(";subject=")){ 
					liste = TraiteVersion4(i);
				}
				else{
					liste = TraiteVersion51(i);
				}
				w+=("<liste>\n");
				w+=("<homepage>" + liste.getLien() + "</homepage>\n");
				w+=("<listAddress>" + liste.getNom() + "</listAddress>\n");
				w+=("<owner>"+liste.getOwner()+"</owner>");
				w+=("<suscriber>"+liste.getSubscriber()+"</suscriber>");
				w+=("<editor>"+liste.getEditor()+"</editor>");
				w+=("<subject>");
				if (_descriptionCharacterNumber == 0)
					w+=(liste.getSujet().replaceAll("&","&#38;"));
				else
					w+=(liste.getSujet().substring(0,_descriptionCharacterNumber).replaceAll("&","&#38;"));
				w+=("</subject>\n");
				w+=("</liste>\n");
	
			}
		}
		return w;
	}
	
	private Liste TraiteVersion4(int i){
		Liste liste = new Liste();
		String[] unAbonnement = null;
		String[] temp;
		nbAbonnement = _abonnements.length;
		log.debug("version 4");
		//recuperation du champ proprietaire (0 ou1)
		unAbonnement = _abonnements[i].split("isOwner=");
		temp = unAbonnement[1].split("[;]");
		liste.setOwner(temp[0]);
		//recuperation du champ homepage
		unAbonnement = _abonnements[i].split("homepage=");
		temp = unAbonnement[1].split("[;]");
		liste.setLien(temp[0]);
		//recuperation du champ sujet (description de la liste)
		unAbonnement = unAbonnement[1].split("subject=");
		temp = unAbonnement[1].split(";listAddress=");
		liste.setSujet(temp[0]);
		//recuperation du champ listAddress (nom de la liste)
		temp = temp[1].split(";isEditor=");
		liste.setNom(temp[0]);
		//recuperation du champ editeur (0 ou1)
		unAbonnement = _abonnements[i].split("isEditor=");
		temp = unAbonnement[1].split("[;]"); 
		liste.setEditor(temp[0]);
		//recuperation du champ abonne (0 ou1)
		unAbonnement = _abonnements[i].split("isSubscriber=");
		liste.setSubscriber(unAbonnement[1]);
		return liste;
	}
	
	private Liste TraiteVersion51(int i){
		Liste liste = new Liste();
		String[] unAbonnement = null;
		String[] temp;
		log.debug("version 5");
		//recuperation du champ homepage
		unAbonnement = _abonnements[i].split("homepage=");
		temp = unAbonnement[1].split("[;]");
		liste.setLien(temp[0]);
		log.debug("lien = " + liste.getLien());
		//recuperation du champ listAddress (nom de la liste)
		unAbonnement = unAbonnement[1].split(";listAddress=");
		temp = unAbonnement[1].split("[;]");
		liste.setNom(temp[0]);
		log.debug("nom = " + liste.getNom());
		//recuperation du champ editeur (0 ou1)
		unAbonnement = _abonnements[i].split("isEditor=");
		temp = unAbonnement[1].split("[;]"); 
		liste.setEditor(temp[0]);
		//recuperation du champ proprietaire (0 ou1)
		unAbonnement = _abonnements[i].split("isOwner=");
		temp = unAbonnement[1].split("[;]");
		liste.setOwner(temp[0]);
		//recuperation du champ sujet (description de la liste)		
		unAbonnement = unAbonnement[1].split(";subject=");
		temp = unAbonnement[1].split("[;]");
		liste.setSujet(temp[0]);
		//recuperation du champ abonne (0 ou1)
		unAbonnement = _abonnements[i].split("isSubscriber=");
		liste.setSubscriber(unAbonnement[1]);
		log.debug("sujet = " + liste.getSujet());
		return liste;
	}
}
