<?xml version='1.0' encoding='ISO-8859-1'?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="content">
    <xsl:variable name="mediaPath">media/org/esupportail/portal/channels/CSympaMultiServeur/logo.gif</xsl:variable>
    
    <xsl:choose>
      <xsl:when test='image'>
	<img><xsl:attribute name="src"><xsl:value-of select="image"/></xsl:attribute><xsl:attribute name="alt">logo SYMPA</xsl:attribute></img>
      </xsl:when>
      <xsl:otherwise>
	<img src="{$mediaPath}" alt="logo SYMPA"/>
      </xsl:otherwise>
    </xsl:choose>
    
    <xsl:choose>
      <xsl:when test='display="owner"'>
          Liste des listes dont vous &#234;tes propri&#233;taire <xsl:value-of select="defaultText"/>. <br/><br/>
      
	<xsl:for-each  select="liste">
	  <xsl:if test='owner="1"'>
	    <ul>
	      <li><a class="uportal-text"><xsl:attribute name="href"><xsl:value-of select="homepage"/></xsl:attribute><xsl:attribute name="target">_blank</xsl:attribute><b><xsl:text> </xsl:text><xsl:value-of select="listAddress"/></b></a> : 
	      <xsl:value-of select="subject"/> 
	      </li>
	    </ul>
	  </xsl:if>
	</xsl:for-each>
	
      </xsl:when>
      <xsl:when test='display="subscriber"'>
          Liste des listes auxquelles vous &#234;tes abonn&#233;es <xsl:value-of select="defaultText"/>. <br/><br/>
      
	<xsl:for-each  select="liste">
	  <xsl:if test='subscriber="1"'>
	    <ul>
	      <li><a class="uportal-text"><xsl:attribute name="href"><xsl:value-of select="homepage"/></xsl:attribute><xsl:attribute name="target">_blank</xsl:attribute><b><xsl:text> </xsl:text><xsl:value-of select="listAddress"/></b></a> : 
	      <xsl:value-of select="subject"/>
	      </li>
	    </ul>
	  </xsl:if>
	</xsl:for-each>
	
      </xsl:when>
      <xsl:when test='display="editor"'>
          Liste des listes dont vous &#234;tes mod&#233;rateur <xsl:value-of select="defaultText"/>. <br/><br/>
      
	<xsl:for-each  select="liste">
	  <xsl:if test='editor="1"'>
	    <ul>
	      <li><a class="uportal-text"><xsl:attribute name="href"><xsl:value-of select="homepage"/></xsl:attribute><xsl:attribute name="target">_blank</xsl:attribute><b><xsl:text> </xsl:text><xsl:value-of select="listAddress"/></b></a> : 
	      <xsl:value-of select="subject"/> :  <xsl:value-of select="owner"/> :  <xsl:value-of select="suscriber"/> :  <xsl:value-of select="editor"/>  
	      </li>
	    </ul>
	  </xsl:if>
	</xsl:for-each>
	
      </xsl:when>
      <xsl:otherwise>
          Liste de vos Abonnements <xsl:value-of select="defaultText"/>. <br/><br/>
      
	<xsl:for-each  select="liste">
	  <ul>
	    <li><a class="uportal-text"><xsl:attribute name="href"><xsl:value-of select="homepage"/></xsl:attribute><xsl:attribute name="target">_blank</xsl:attribute><b><xsl:text> </xsl:text><xsl:value-of select="listAddress"/></b></a> : 
	    <xsl:value-of select="subject"/> :  <xsl:value-of select="owner"/> :  <xsl:value-of select="suscriber"/> :  <xsl:value-of select="editor"/>  
	    </li>
	  </ul>
	</xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
    
  </xsl:template>
  
  
  
</xsl:stylesheet>