/*
 * Decompiled with CFR 0.152.
 */
package fr.univrennes1.cri.utils;

import fr.univrennes1.cri.utils.ApoCasProxyException;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class Config {
    private static Config singleton = null;
    private String urlLDAP = null;
    private String userLDAP = null;
    private String pwdLDAP = null;
    private String contextDeRechercheLDAP = null;
    private String attributDeRechercheLDAP = null;
    private String attributVouluLDAP = null;
    private String requeteSQL = null;

    public Config() throws IOException, ApoCasProxyException {
        try {
            Class<?> requestingClass = this.getClass();
            URL resourceURL = requestingClass.getResource("/properties/apoweb.xml");
            if (resourceURL == null) {
                throw new ApoCasProxyException("apoweb.xml does not exist ");
            }
            String path = resourceURL.getFile();
            Digester dig = new Digester();
            dig.push((Object)this);
            dig.addCallMethod("ROOT", "addRoot", 7);
            dig.addCallParam("ROOT/LDAP/LDAP-url", 0);
            dig.addCallParam("ROOT/LDAP/LDAP-user", 1);
            dig.addCallParam("ROOT/LDAP/LDAP-pwd", 2);
            dig.addCallParam("ROOT/LDAP/LDAP-contextDeRecherche", 3);
            dig.addCallParam("ROOT/LDAP/LDAP-attributDeRecherche", 4);
            dig.addCallParam("ROOT/LDAP/LDAP-attributVoulu", 5);
            dig.addCallParam("ROOT/SQL/SQL-requeteSQL", 6);
            dig.parse(path);
        }
        catch (IOException e) {
            throw new ApoCasProxyException("Impossible to load file apoweb.xml : " + e);
        }
        catch (SAXException e) {
            throw new ApoCasProxyException("Erreur de parsage de fichier : " + e);
        }
    }

    public void addRoot(String url, String user, String pwd, String contextDeRecherche, String attributDeRecherche, String attributVoulu, String requete) {
        this.urlLDAP = url;
        this.userLDAP = user;
        this.pwdLDAP = pwd;
        this.contextDeRechercheLDAP = contextDeRecherche;
        this.attributDeRechercheLDAP = attributDeRecherche;
        this.attributVouluLDAP = attributVoulu;
        this.requeteSQL = requete;
    }

    public static Config getInstance() throws IOException, ApoCasProxyException {
        if (singleton == null) {
            singleton = new Config();
        }
        return singleton;
    }

    public String getAttributDeRechercheLDAP() {
        return this.attributDeRechercheLDAP;
    }

    public String getAttributVouluLDAP() {
        return this.attributVouluLDAP;
    }

    public String getUrlLDAP() {
        return this.urlLDAP;
    }

    public String getPwdLDAP() {
        return this.pwdLDAP;
    }

    public String getUserLDAP() {
        return this.userLDAP;
    }

    public String getContextDeRechercheLDAP() {
        return this.contextDeRechercheLDAP;
    }

    public String getRequeteSQL() {
        return this.requeteSQL;
    }
}

