/*
 * Decompiled with CFR 0.152.
 */
package fr.univrennes1.cri.utils;

import fr.univrennes1.cri.utils.ApoCasProxyException;
import fr.univrennes1.cri.utils.Config;
import fr.univrennes1.cri.utils.Connexion;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class Etudiant {
    private String numero = null;
    private String dateNaiss = null;
    Connection connect = null;

    public Etudiant(String user) throws ApoCasProxyException {
        ResultSet res = null;
        Statement pstmt = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", Config.getInstance().getUrlLDAP());
            InitialDirContext ctx = new InitialDirContext(env);
            String[] param = new String[]{Config.getInstance().getAttributVouluLDAP()};
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(param);
            String filter = Config.getInstance().getAttributDeRechercheLDAP() + "=" + user;
            NamingEnumeration<SearchResult> answer = ctx.search(Config.getInstance().getContextDeRechercheLDAP(), filter, ctls);
            SearchResult rs = answer.next();
            String resultat = (String)rs.getAttributes().get(param[0]).get(0);
            this.connect = Connexion.OpenConnection();
            String Query = Config.getInstance().getRequeteSQL();
            pstmt = this.connect.prepareStatement(Query);
            pstmt.setString(1, resultat);
            res = pstmt.executeQuery();
            res.next();
            this.numero = res.getString(1);
            this.dateNaiss = res.getString(2);
        }
        catch (Exception e) {
            throw new ApoCasProxyException("Erreur LDAP ou SQL : " + e);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
                if (this.connect != null) {
                    Connexion.CloseConnection(this.connect);
                }
            }
            catch (Exception e) {
                throw new ApoCasProxyException("Erreur fermeture connexion : " + e);
            }
        }
    }

    public String getDateNaiss() {
        return this.dateNaiss;
    }

    public String getNumero() {
        return this.numero;
    }
}

