/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas;

import java.io.IOException;
import java.net.URL;
import javax.servlet.jsp.JspException;
import org.apache.commons.digester.Digester;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Config {
    private static Config singleton = null;
    private String authenticateURL = null;
    private String validateURL = null;
    private String logoutURL = null;

    public String getAuthenticateURL() {
        return this.authenticateURL;
    }

    public String getLogoutURL() {
        return this.logoutURL;
    }

    public String getValidateURL() {
        return this.validateURL;
    }

    public Config() throws IOException, JspException {
        try {
            Class<?> requestingClass = this.getClass();
            URL resourceURL = requestingClass.getResource("/properties/cas.xml");
            if (resourceURL == null) {
                throw new JspException("cas.xml does not exist ");
            }
            Digester dig = new Digester();
            dig.push((Object)this);
            dig.addCallMethod("cas", "addRoot", 4);
            dig.addCallParam("cas", 0, "hostname");
            dig.addCallParam("cas", 1, "port");
            dig.addCallParam("cas", 2, "base_uri");
            dig.addCallParam("cas", 3, "version");
            dig.parse(new InputSource(resourceURL.toExternalForm()));
        }
        catch (IOException e) {
            throw new JspException("Impossible to load file cas.xml : " + e);
        }
        catch (SAXException e) {
            throw new JspException((Throwable)e);
        }
    }

    public void addRoot(String server, String port, String baseURI, String version) {
        String baseUrlCas = "https://" + server + ":" + port + baseURI;
        this.authenticateURL = String.valueOf(baseUrlCas) + "/login";
        this.logoutURL = String.valueOf(baseUrlCas) + "/logout";
        this.validateURL = String.valueOf(baseUrlCas) + "/validate";
    }

    public static Config getInstance() throws IOException, JspException {
        if (singleton == null) {
            singleton = new Config();
        }
        return singleton;
    }
}

