/**
 * Cre le 29 janv. 2004
 * Par Sbastien Gougeon
 * Centre de Ressources Informatiques
 * Universit de Rennes 1
 * sebastien.gougeon@univ-rennes1.fr
 * 
 */
package fr.univrennes1.cri.utils;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;


public class Etudiant {

	private String numero = null;
	private String dateNaiss = null;
	Connection connect = null;

	/**
	 * Constructeur
	 * @param user String
	 * @param connect Connection
	 * @throws ApoCasProxyException
	 */
	
	public Etudiant(String user) throws ApoCasProxyException {
		ResultSet res = null;
		PreparedStatement pstmt = null;
		
		try {
			// Interrogation LDAP
			Hashtable env = new Hashtable();
			env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.ldap.LdapCtxFactory");
			env.put(Context.PROVIDER_URL, Config.getInstance().getUrlLDAP());
			DirContext ctx = new InitialDirContext(env);
			String[] param = {Config.getInstance().getAttributVouluLDAP()};
			SearchControls ctls = new SearchControls();
			ctls.setReturningAttributes(param);
			String filter = Config.getInstance().getAttributDeRechercheLDAP()+"="+user;	
			NamingEnumeration answer = ctx.search (Config.getInstance().getContextDeRechercheLDAP(), filter, ctls);
			SearchResult rs = (SearchResult) answer.next();		
			String resultat = (String) rs.getAttributes().get(param[0]).get(0);
			
			//Interrogation SQL de la base Apogee
			connect = Connexion.OpenConnection();
			String Query = Config.getInstance().getRequeteSQL();
			pstmt = connect.prepareStatement(Query);
			pstmt.setString(1,resultat);
			res = pstmt.executeQuery();
			res.next();
			numero = res.getString(1);
			dateNaiss = res.getString(2);
		}
		catch (Exception e) {
			throw new ApoCasProxyException("Erreur LDAP ou SQL : "+e);
		}
		finally{
			try {
				if (res != null) res.close();
				if (pstmt != null) pstmt.close();
				if (connect != null) Connexion.CloseConnection(connect);
			}
			catch (Exception e) {
				throw new ApoCasProxyException("Erreur fermeture connexion : "+e);
			}
		}
	}
	
	/**
	 * Accesseur
	 * @return la date de naissance de l'utilisateur
	 */
	public String getDateNaiss() {
		return dateNaiss;
	}

	/**
	 * Accesseur
	 * @return le numro tudiant de l'utilisateur
	 */
	public String getNumero() {
		return numero;
	}

}