/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.taglib;

import edu.yale.its.tp.cas.CASServiceUtil;
import edu.yale.its.tp.cas.Config;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

public class CasTag
extends TagSupport {
    private int scope;
    private boolean skip;

    public int doStartTag() throws JspException {
        try {
            this.skip = false;
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
            if (this.pageContext.getAttribute(this.id, this.scope) != null) {
                return 0;
            }
            String ticket = request.getParameter("ticket");
            if (ticket == null || ticket.equals("")) {
                response.sendRedirect(String.valueOf(Config.getInstance().getAuthenticateURL()) + "?service=" + HttpUtils.getRequestURL((HttpServletRequest)request));
                this.skip = true;
                return 0;
            }
            String netid = CASServiceUtil.validate(HttpUtils.getRequestURL((HttpServletRequest)request).toString(), ticket);
            if (netid == null) {
                throw new JspTagException("Unexpected CAS authentication error.");
            }
            this.pageContext.setAttribute(this.id, (Object)netid, this.scope);
            return 0;
        }
        catch (IOException ex) {
            throw new JspTagException(ex.getMessage());
        }
    }

    public int doEndTag() {
        if (this.skip) {
            return 5;
        }
        return 6;
    }

    public void setScope(String scope) {
        if (scope.equals("page")) {
            this.scope = 1;
        } else if (scope.equals("request")) {
            this.scope = 2;
        } else if (scope.equals("session")) {
            this.scope = 3;
        } else if (scope.equals("application")) {
            this.scope = 4;
        } else {
            throw new IllegalArgumentException("invalid scope");
        }
    }

    public CasTag() {
        this.init();
    }

    public void release() {
        super.release();
        this.init();
    }

    private void init() {
        this.scope = 1;
    }
}

