package fr.univrennes1.cri.utils;

/**
 * @author S.Gougeon
 * date : 18 sept. 2003
 * Centre de Ressousrces Informatiques
 * Universit de Rennes 1
 * 
 * 
 */

import java.io.IOException;
import java.net.URL;
import org.apache.commons.digester.*;
import org.xml.sax.SAXException;

public class Config
{     
	private static Config singleton = null;
	private String urlLDAP = null;
	private String userLDAP = null;
	private String pwdLDAP = null;
	private String contextDeRechercheLDAP = null;
	private String attributDeRechercheLDAP = null;
	private String attributVouluLDAP = null;
	private String requeteSQL = null;
	private String tomcatPoolName = null;


	
	/**
	 * Constructeur
	 * @throws IOException
	 * @throws JspException
	 */
	public Config() throws IOException, ApoCasProxyException {
		try {
			Class requestingClass = this.getClass();
			URL resourceURL = requestingClass.getResource("/properties/apoweb.xml");
			if (resourceURL == null){
				throw new ApoCasProxyException ("apoweb.xml does not exist ");
			}
			String path = resourceURL.getFile();
			//Cration d'une instance Digester 
			Digester dig = new Digester();
			//On rend l'objet disponible  la manipulation en le mettant en haut de la pile
			dig.push(this);
			//Chaque fois que "ROOT" sera lu  la lecture du fichier de config on fera appelle  la mthode addRoot() avec 4 paramtres
			dig.addCallMethod("ROOT","addRoot",8);
			//Premier paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/LDAP/LDAP-url",0);
			//Deuxime paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/LDAP/LDAP-user",1);
			//Troisime paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/LDAP/LDAP-pwd",2);
			//Quatrime paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/LDAP/LDAP-contextDeRecherche",3);
			//Cinquime paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/LDAP/LDAP-attributDeRecherche",4);
			//Sixime paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/LDAP/LDAP-attributVoulu",5);
			//Septime paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/SQL/SQL-requeteSQL",6);
			//Huitime paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/TOMCAT/POOL-name",7);
			dig.parse(path);
		}
		catch (IOException e) {
				 throw new ApoCasProxyException("Impossible to load file apoweb.xml : "+e);
		} catch (SAXException e) {
			throw new ApoCasProxyException("Erreur de parsage de fichier : "+e);
		} 
	}
	
	/**
	 * Permet d'affecter les variables de la classe avec celles du fichier de configuration apoweb.xml
	 * @param url
	 * @param user
	 * @param pwd
	 * @param contextDeRecherche
	 * @param attributRecherche
	 * @param elementVoulu
	 * @param requete
	 */
	
	public void addRoot(String url, String user, String pwd, String contextDeRecherche, String attributDeRecherche, String attributVoulu, String requete, String poolName){
		urlLDAP = url;
		userLDAP = user;
		pwdLDAP = pwd;
		contextDeRechercheLDAP = contextDeRecherche;
		attributDeRechercheLDAP = attributDeRecherche;
		attributVouluLDAP = attributVoulu;
		requeteSQL = requete;
		tomcatPoolName = poolName;
		
	}
	/**
	 * Accesseur
	 * @return Config Instance
	 * @throws IOException
	 * @throws JspException
	 */
	public static Config getInstance() throws IOException, ApoCasProxyException {
		if(singleton == null) {
			singleton = new Config();
		}
		return singleton;
	}

	/**
	 * Accesseur
	 * @return attribut de recherche LDAP
	 */
	public String getAttributDeRechercheLDAP() {
		return attributDeRechercheLDAP;
	}


	/**
	 * Accesseur
	 * @return attribut que l'on veut recuperer de LDAP
	 */
	public String getAttributVouluLDAP() {
		return attributVouluLDAP;
	}


	/**
	 * Accesseur
	 * @return url du serveur LDAP
	 */
	public String getUrlLDAP() {
		return urlLDAP;
	}

	/**
	 * Accesseur
	 * @return le mot de passe du user LDAP (si la connexion n'est pas anonyme)
	 */
	public String getPwdLDAP() {
		return pwdLDAP;
	}

	/**
	 * Accesseur
	 * @return l'utilisateur LDAP (si la connexion n'est pas anonyme)
	 */
	public String getUserLDAP() {
		return userLDAP;
	}

	/**
	 * Accesseur
	 * @return le contexte de la recherche
	 */
	public String getContextDeRechercheLDAP() {
		return contextDeRechercheLDAP;
	}

	/**
	 * Accesseur
	 * @return la requete SQL pour la base de donnee Apogee
	 */
	public String getRequeteSQL() {
		return requeteSQL;
	}
	/**
	 * Accesseur
	 * @return Le nom du pool tomcat pour Apoge
	 */
	public String getTomcatPoolName() {
		return tomcatPoolName;
	}
}