<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dir="http://apache.org/cocoon/directory/2.0">
      <xsl:param name="cssfile" />
	<xsl:param name="localURI" />

    	<xsl:param name="detail" select="'none'"/>	
   	
	
  	<!-- structure principale --> 
   
	<!-- Elements lies a la navigation -->
	<xsl:template match="injacNav">
		<xsl:apply-templates />
	</xsl:template>
	
	<xsl:template match="injacNavPan">
      	<div id="iNavPan">
		<ul type="disc" id="currentFolder">
         		<xsl:apply-templates />
		</ul>
	</div>
   	</xsl:template>
	
	<xsl:template match="injacNavBar">
      	<div id="iNavBar">
		
		<div id="iCurrentLoc"><a href="{./upnode}?cssfile={$cssfile}"><xsl:value-of select="upnode"/></a><xsl:value-of select="currentloc"/></div>
		
		<div id="iBackUri"><a href="{./upnode}?cssfile={$cssfile}">Retour</a></div>
      	</div>
   	</xsl:template>


	<!-- Elements de repertoire -->
	
	<xsl:template match="current">   	  
	<div id="current" ><xsl:value-of select="name"/></div>
   	</xsl:template>
   
   	<xsl:template match="directories">
	<div id="iDirectories"><xsl:apply-templates /></div>

   	</xsl:template>
	
   	<xsl:template match="files">
	<div id="iFiles"><xsl:apply-templates /></div>
   	</xsl:template>

 
 
   	<xsl:template match="directory">
       	<li class="directory">		
		<a href="{$localURI}{../@parent}{name}?cssfile={$cssfile}">
			<xsl:value-of select="name" />
		</a>
		<xsl:choose>
			<xsl:when test="$detail='none'" />
			<xsl:when test="$detail='medium'">
				<ul type="circle">
				<li id="fileDate">creation : <xsl:value-of select="date" /></li>
				<!--li id="fileDate">modification : <xsl:value-of select="lastModified" /></li-->
				</ul>
      		</xsl:when>
			<xsl:when test="$detail='full'">
				<ul type="circle">
				<li id="fileDate">creation : <xsl:value-of select="date" /></li>
				<li class="fileSize">taille : <xsl:value-of select="size" /> octets</li>
				<li class="uri">URI : <xsl:value-of select="uri" /> octets</li>
				</ul>
      		</xsl:when>
		</xsl:choose>
		</li>
		
   	</xsl:template>

   	<xsl:template match="file">
      	<li class="file">
	<!-- Test pour eliminer le slash-->
	<xsl:choose>
		<xsl:when test="string-length(../@parent) != 1">
			<a href="{$localURI}{../@parent}/{name}?cssfile={$cssfile}">
				<xsl:value-of select="name" />
			</a>
		</xsl:when>
		<xsl:otherwise>
			<a href="{$localURI}{name}?cssfile={$cssfile}">
				<xsl:value-of select="name" />
			</a>
		</xsl:otherwise>
	</xsl:choose>

       	<xsl:choose>
			<xsl:when test="$detail='none'" />
			<xsl:when test="$detail='medium'">
				<ul type="circle">
					<li class="fileDate">creation : <xsl:value-of select="date" /></li>
					<li class="fileSize">taille : <xsl:value-of select="size" /> octets</li>
				</ul>	
			</xsl:when>
			<xsl:when test="$detail='full'">
				<ul type="circle">
					<li class="fileDate">creation : <xsl:value-of select="date" /></li>
					<li class="fileDate">modification : <xsl:value-of select="lastModified" /></li>
					<li class="fileSize">taille : <xsl:value-of select="size" /> octets</li>
					<li class="uri">URI : <xsl:value-of select="uri" /> octets</li>
				</ul>	
			</xsl:when>
		</xsl:choose>
      	</li>
   	</xsl:template>
   
    
</xsl:stylesheet>

