<?xml version="1.0" encoding="iso-8859-1" ?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:error="http://apache.org/cocoon/error/2.1">

  <xsl:param name="contextPath"/>

  <!-- let sitemap override default page title -->
  <xsl:param name="pageTitle" select="//error:notify/error:title"/>
  <xsl:template match="error:notify">
    <html>
      <head>
        <title>
          <xsl:value-of select="$pageTitle"/>
        </title>
        <link href="{$contextPath}/styles/main.css" type="text/css" rel="stylesheet"/>
        <style>
          h1 { color: #336699; text-align: left; margin: 0px 0px 30px 0px; padding: 0px; border-width: 0px 0px 1px 0px; border-style: solid; border-color: #336699;}
          p.message { padding: 10px 30px 10px 30px; font-weight: bold; font-size: 130%; border-width: 1px; border-style: dashed; border-color: #336699; }
          p.description { padding: 10px 30px 20px 30px; border-width: 0px 0px 1px 0px; border-style: solid; border-color: #336699;}
          p.topped { padding-top: 10px; border-width: 1px 0px 0px 0px; border-style: solid; border-color: #336699; }
          pre { font-size: 120%; }
        </style>
        <script src="{$contextPath}/scripts/main.js" type="text/javascript"/>
      </head>
      <body>
        <xsl:apply-templates select="." mode="onload"/>
        <h1><xsl:value-of select="$pageTitle"/> -- Joyeux Dbogage</h1>

        <p class="message">
          <xsl:value-of select="error:message"/>
        </p>

        <p class="description">
          <xsl:value-of select="error:description"/>
        </p>

        <xsl:apply-templates select="error:extra"/>

        <p>
          Merci quand mme d'avoir cru que a marchait.
        </p>

        <p class="topped">
          The <a href="http://cocoon.apache.org/">Apache Cocoon</a> Project
        </p>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="error:notify" mode="onload">
    <xsl:attribute name="onload">
      <xsl:for-each select="error:extra[contains(@error:description,'stacktrace')]">
        <xsl:text>toggle('</xsl:text>
        <xsl:value-of select="@error:description"/>
        <xsl:text>');</xsl:text>
      </xsl:for-each>
    </xsl:attribute>
  </xsl:template>

  <xsl:template match="error:extra">
    <xsl:choose>
     <xsl:when test="contains(@error:description,'stacktrace')">
      <p class="stacktrace">
       <span class="description"><xsl:value-of select="@error:description"/></span>
       <span class="switch" id="{@error:description}-switch" onclick="toggle('{@error:description}')">[hide]</span>
       <pre id="{@error:description}">
         <xsl:value-of select="translate(.,'&#13;','')"/>
       </pre>
      </p>
     </xsl:when>
     <xsl:otherwise>
      <p class="extra">
       <span class="description"><xsl:value-of select="@error:description"/>:&#160;</span>
       <xsl:value-of select="."/>
      </p>
     </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
