/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.SingleThreaded;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.flow.ContinuationsManager;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.components.flow.util.PipelineUtil;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Redirector;
import org.apache.excalibur.source.SourceUtil;

public abstract class AbstractInterpreter
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable,
Interpreter,
SingleThreaded,
Configurable,
Disposable {
    protected org.apache.avalon.framework.context.Context avalonContext;
    protected ArrayList needResolve = new ArrayList();
    protected Context context;
    protected ServiceManager manager;
    protected ContinuationsManager continuationsMgr;
    protected boolean reloadScripts;
    protected long checkTime;

    public void configure(Configuration config) throws ConfigurationException {
        this.reloadScripts = config.getChild("reload-scripts").getValueAsBoolean(false);
        this.checkTime = config.getChild("check-time").getValueAsLong(1000L);
    }

    public void service(ServiceManager sm) throws ServiceException {
        this.manager = sm;
        this.continuationsMgr = (ContinuationsManager)sm.lookup(ContinuationsManager.ROLE);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this.avalonContext = context;
        this.context = (Context)context.get((Object)"environment-context");
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.continuationsMgr);
            this.continuationsMgr = null;
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String source) {
        AbstractInterpreter abstractInterpreter = this;
        synchronized (abstractInterpreter) {
            this.needResolve.add(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String uri, Object biz, OutputStream out) throws Exception {
        PipelineUtil pipeUtil = new PipelineUtil();
        try {
            pipeUtil.contextualize(this.avalonContext);
            pipeUtil.service(this.manager);
            pipeUtil.processToStream(uri, biz, out);
        }
        finally {
            pipeUtil.dispose();
        }
    }

    public void forwardTo(String uri, Object bizData, WebContinuation continuation, Redirector redirector) throws Exception {
        Map objectModel;
        if (SourceUtil.indexOfSchemeColon((String)uri) == -1) {
            uri = "cocoon:/" + uri;
            objectModel = ContextHelper.getObjectModel(this.avalonContext);
            FlowHelper.setWebContinuation(objectModel, continuation);
            FlowHelper.setContextObject(objectModel, bizData);
            if (redirector.hasRedirected()) {
                throw new IllegalStateException("Pipeline has already been processed for this request");
            }
        } else {
            throw new Exception("uri is not allowed to contain a scheme (cocoon:/ is always automatically used)");
        }
        objectModel.put("cocoon:forward", "true");
        redirector.redirect(false, uri);
    }
}

