/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.commons.lang.SystemUtils;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class StatusGenerator
extends ServiceableGenerator {
    protected StoreJanitor storejanitor;
    protected Store store_persistent;
    protected static final String namespace = "http://apache.org/cocoon/status/2.0";
    protected static final String xlinkNamespace = "http://www.w3.org/1999/xlink";
    protected static final String xlinkPrefix = "xlink";

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        if (this.manager.hasService(StoreJanitor.ROLE)) {
            this.storejanitor = (StoreJanitor)manager.lookup(StoreJanitor.ROLE);
        } else {
            this.getLogger().info("StoreJanitor is not available. Sorry, no cache statistics");
        }
        if (this.manager.hasService(Store.PERSISTENT_STORE)) {
            this.store_persistent = (Store)this.manager.lookup(Store.PERSISTENT_STORE);
        } else {
            this.getLogger().info("Persistent Store is not available. Sorry no cache statistics about it.");
        }
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.store_persistent);
            this.manager.release((Object)this.storejanitor);
            this.store_persistent = null;
            this.storejanitor = null;
        }
        super.dispose();
    }

    public void generate() throws SAXException {
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("", namespace);
        this.contentHandler.startPrefixMapping(xlinkPrefix, xlinkNamespace);
        this.genStatus(this.contentHandler);
        this.contentHandler.endPrefixMapping(xlinkPrefix);
        this.contentHandler.endPrefixMapping("");
        this.contentHandler.endDocument();
    }

    private void genStatus(ContentHandler ch) throws SAXException {
        String localHost;
        String dateTime = DateFormat.getDateTimeInstance().format(new Date());
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.getLogger().debug("StatusGenerator:UnknownHost", (Throwable)e);
            localHost = "";
        }
        catch (SecurityException e) {
            this.getLogger().debug("StatusGenerator:Security", (Throwable)e);
            localHost = "";
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(namespace, "date", "date", "CDATA", dateTime);
        atts.addAttribute(namespace, "host", "host", "CDATA", localHost);
        ch.startElement(namespace, "statusinfo", "statusinfo", atts);
        this.genVMStatus(ch);
        ch.endElement(namespace, "statusinfo", "statusinfo");
    }

    private void genVMStatus(ContentHandler ch) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this.startGroup(ch, "vm");
        this.startGroup(ch, "memory");
        this.addValue(ch, "total", String.valueOf(Runtime.getRuntime().totalMemory()));
        this.addValue(ch, "free", String.valueOf(Runtime.getRuntime().freeMemory()));
        this.endGroup(ch);
        this.startGroup(ch, "jre");
        this.addValue(ch, "version", SystemUtils.JAVA_VERSION);
        atts.clear();
        atts.addAttribute(xlinkNamespace, "type", "xlink:type", "CDATA", "simple");
        atts.addAttribute(xlinkNamespace, "href", "xlink:href", "CDATA", SystemUtils.JAVA_VENDOR_URL);
        this.addValue(ch, "java-vendor", SystemUtils.JAVA_VENDOR, atts);
        this.endGroup(ch);
        this.startGroup(ch, "operating-system");
        this.addValue(ch, "name", SystemUtils.OS_NAME);
        this.addValue(ch, "architecture", SystemUtils.OS_ARCH);
        this.addValue(ch, "version", SystemUtils.OS_VERSION);
        this.endGroup(ch);
        String classpath = SystemUtils.JAVA_CLASS_PATH;
        ArrayList<String> paths = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(classpath, SystemUtils.PATH_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            paths.add(tokenizer.nextToken());
        }
        this.addMultilineValue(ch, "classpath", paths);
        if (this.storejanitor != null) {
            this.startGroup(ch, "Store-Janitor");
            Iterator i = this.storejanitor.iterator();
            while (i.hasNext()) {
                Store store = (Store)i.next();
                this.startGroup(ch, store.getClass().getName() + " (hash = 0x" + Integer.toHexString(store.hashCode()) + ")");
                int size = 0;
                int empty = 0;
                atts.clear();
                atts.addAttribute(namespace, "name", "name", "CDATA", "cached");
                ch.startElement(namespace, "value", "value", atts);
                Enumeration e = store.keys();
                atts.clear();
                while (e.hasMoreElements()) {
                    ++size;
                    Object key = e.nextElement();
                    Object val = store.get(key);
                    String line = null;
                    if (val == null) {
                        ++empty;
                        continue;
                    }
                    line = key + " (class: " + val.getClass().getName() + ")";
                    ch.startElement(namespace, "line", "line", atts);
                    ch.characters(line.toCharArray(), 0, line.length());
                    ch.endElement(namespace, "line", "line");
                }
                if (size == 0) {
                    ch.startElement(namespace, "line", "line", atts);
                    String value = "[empty]";
                    ch.characters(value.toCharArray(), 0, value.length());
                    ch.endElement(namespace, "line", "line");
                }
                ch.endElement(namespace, "value", "value");
                this.addValue(ch, "size", String.valueOf(size) + " items in cache (" + empty + " are empty)");
                this.endGroup(ch);
            }
            this.endGroup(ch);
        }
        if (this.store_persistent != null) {
            this.startGroup(ch, this.store_persistent.getClass().getName() + " (hash = 0x" + Integer.toHexString(this.store_persistent.hashCode()) + ")");
            int size = 0;
            int empty = 0;
            atts.clear();
            atts.addAttribute(namespace, "name", "name", "CDATA", "cached");
            ch.startElement(namespace, "value", "value", atts);
            Enumeration enumeration = this.store_persistent.keys();
            while (enumeration.hasMoreElements()) {
                ++size;
                Object key = enumeration.nextElement();
                Object val = this.store_persistent.get(key);
                String line = null;
                if (val == null) {
                    ++empty;
                    continue;
                }
                line = key + " (class: " + val.getClass().getName() + ")";
                ch.startElement(namespace, "line", "line", atts);
                ch.characters(line.toCharArray(), 0, line.length());
                ch.endElement(namespace, "line", "line");
            }
            if (size == 0) {
                ch.startElement(namespace, "line", "line", atts);
                String value = "[empty]";
                ch.characters(value.toCharArray(), 0, value.length());
                ch.endElement(namespace, "line", "line");
            }
            ch.endElement(namespace, "value", "value");
            this.addValue(ch, "size", String.valueOf(size) + " items in cache (" + empty + " are empty)");
            this.endGroup(ch);
        }
        this.endGroup(ch);
    }

    private void startGroup(ContentHandler ch, String name) throws SAXException {
        this.startGroup(ch, name, null);
    }

    private void startGroup(ContentHandler ch, String name, Attributes atts) throws SAXException {
        AttributesImpl ai = atts == null ? new AttributesImpl() : new AttributesImpl(atts);
        ai.addAttribute(namespace, "name", "name", "CDATA", name);
        ch.startElement(namespace, "group", "group", ai);
    }

    private void endGroup(ContentHandler ch) throws SAXException {
        ch.endElement(namespace, "group", "group");
    }

    private void addValue(ContentHandler ch, String name, String value) throws SAXException {
        this.addValue(ch, name, value, null);
    }

    private void addValue(ContentHandler ch, String name, String value, Attributes atts) throws SAXException {
        AttributesImpl ai = atts == null ? new AttributesImpl() : new AttributesImpl(atts);
        ai.addAttribute(namespace, "name", "name", "CDATA", name);
        ch.startElement(namespace, "value", "value", ai);
        ch.startElement(namespace, "line", "line", new AttributesImpl());
        if (value != null) {
            ch.characters(value.toCharArray(), 0, value.length());
        }
        ch.endElement(namespace, "line", "line");
        ch.endElement(namespace, "value", "value");
    }

    private void addMultilineValue(ContentHandler ch, String name, List values) throws SAXException {
        this.addMultilineValue(ch, name, values, null);
    }

    private void addMultilineValue(ContentHandler ch, String name, List values, Attributes atts) throws SAXException {
        AttributesImpl ai = atts == null ? new AttributesImpl() : new AttributesImpl(atts);
        ai.addAttribute(namespace, "name", "name", "CDATA", name);
        ch.startElement(namespace, "value", "value", ai);
        for (int i = 0; i < values.size(); ++i) {
            String value = (String)values.get(i);
            if (value == null) continue;
            ch.startElement(namespace, "line", "line", new AttributesImpl());
            ch.characters(value.toCharArray(), 0, value.length());
            ch.endElement(namespace, "line", "line");
        }
        ch.endElement(namespace, "value", "value");
    }
}

