/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.dom;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DocumentWrapper
implements Document,
XMLizable {
    Document document = null;

    public DocumentWrapper(Document doc) {
        this.document = doc;
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        DOMStreamer ds = new DOMStreamer(handler);
        ds.stream(this.document.getDocumentElement());
    }

    public String toString() {
        try {
            return XMLUtils.serializeNode(this.document, XMLUtils.createPropertiesForXML(false));
        }
        catch (ProcessingException processingException) {
            return "";
        }
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.document.appendChild(newChild);
    }

    public Node cloneNode(boolean deep) {
        return this.document.cloneNode(deep);
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.document.createAttribute(name);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createAttributeNS(namespaceURI, qualifiedName);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return this.document.createCDATASection(data);
    }

    public Comment createComment(String data) {
        return this.document.createComment(data);
    }

    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    public Element createElement(String tagName) throws DOMException {
        return this.document.createElement(tagName);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createElementNS(namespaceURI, qualifiedName);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return this.document.createEntityReference(name);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.document.createProcessingInstruction(target, data);
    }

    public Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    public NodeList getChildNodes() {
        return this.document.getChildNodes();
    }

    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    public Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    public Element getElementById(String elementId) {
        return this.document.getElementById(elementId);
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.document.getElementsByTagName(tagname);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.document.getElementsByTagNameNS(namespaceURI, localName);
    }

    public Node getFirstChild() {
        return this.document.getFirstChild();
    }

    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    public Node getLastChild() {
        return this.document.getLastChild();
    }

    public String getLocalName() {
        return this.document.getLocalName();
    }

    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    public Node getNextSibling() {
        return this.document.getNextSibling();
    }

    public String getNodeName() {
        return this.document.getNodeName();
    }

    public short getNodeType() {
        return this.document.getNodeType();
    }

    public String getNodeValue() throws DOMException {
        return this.document.getNodeValue();
    }

    public Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    public Node getParentNode() {
        return this.document.getParentNode();
    }

    public String getPrefix() {
        return this.document.getPrefix();
    }

    public Node getPreviousSibling() {
        return this.document.getPreviousSibling();
    }

    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    public boolean hasChildNodes() {
        return this.document.hasChildNodes();
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.document.importNode(importedNode, deep);
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.document.insertBefore(newChild, refChild);
    }

    public boolean isSupported(String feature, String version) {
        return this.document.isSupported(feature, version);
    }

    public void normalize() {
        this.document.normalize();
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return this.document.removeChild(oldChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.document.replaceChild(newChild, oldChild);
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.document.setNodeValue(nodeValue);
    }

    public void setPrefix(String prefix) throws DOMException {
        this.document.setPrefix(prefix);
    }
}

