/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.Hashtable;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.PortalException;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.SAX2BufferImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ChannelRenderingBuffer
extends SAX2BufferImpl {
    protected ChannelManager cm;
    private boolean insideChannelElement = false;
    private Hashtable params;
    private String channelClassName;
    private String channelSubscribeId;
    private String channelPublishId;
    private long timeOut;
    boolean ccaching = false;

    public ChannelRenderingBuffer(ChannelManager chanman) {
        this.cm = chanman;
        this.startBuffering();
        this.setContentHandler(null);
    }

    public ChannelRenderingBuffer(ContentHandler ch, ChannelManager chanman) {
        super(ch);
        this.cm = chanman;
        this.startBuffering();
        this.setContentHandler(null);
    }

    public ChannelRenderingBuffer(XMLReader parent, ChannelManager chanman) {
        super(parent);
        this.cm = chanman;
        this.startBuffering();
        this.setContentHandler(null);
    }

    public ChannelRenderingBuffer(ChannelManager chanman, boolean ccaching) {
        this(chanman);
        this.setCharacterCaching(ccaching);
    }

    public ChannelRenderingBuffer(ContentHandler ch, ChannelManager chanman, boolean ccaching) {
        this(ch, chanman);
        this.setCharacterCaching(ccaching);
    }

    public ChannelRenderingBuffer(XMLReader parent, ChannelManager chanman, boolean ccaching) {
        this(parent, chanman);
        this.setCharacterCaching(ccaching);
    }

    public void setCharacterCaching(boolean setting) {
        this.ccaching = setting;
    }

    public void startDocument() throws SAXException {
        this.insideChannelElement = false;
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.cm.commitToRenderingChannelSet();
        super.endDocument();
    }

    public void startElement(String url, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.insideChannelElement) {
            if (qName.equals("channel")) {
                this.insideChannelElement = true;
                this.channelClassName = atts.getValue("class");
                this.channelSubscribeId = atts.getValue("ID");
                this.channelPublishId = atts.getValue("chanID");
                this.timeOut = Long.parseLong(atts.getValue("timeout"));
                this.params = new Hashtable();
            }
        } else if (qName.equals("parameter")) {
            this.params.put(atts.getValue("name"), atts.getValue("value"));
        }
        super.startElement(url, localName, qName, atts);
    }

    public void endElement(String url, String localName, String qName) throws SAXException {
        if (this.insideChannelElement && qName.equals("channel")) {
            try {
                this.cm.startChannelRendering(this.channelSubscribeId);
            }
            catch (PortalException pe) {
                LogService.log(LogService.ERROR, "ChannelRenderingBuffer::endElement() : unable to start rendering channel! (channelSubscribeId=\"" + this.channelSubscribeId + "\")");
            }
            this.insideChannelElement = false;
        }
        super.endElement(url, localName, qName);
    }
}

