/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.filesystem;

import org.jasig.portal.groups.ComponentGroupServiceDescriptor;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntityGroupStore;
import org.jasig.portal.groups.IEntityGroupStoreFactory;
import org.jasig.portal.groups.IEntityStore;
import org.jasig.portal.groups.IEntityStoreFactory;
import org.jasig.portal.groups.filesystem.FileSystemGroupStore;
import org.jasig.portal.services.LogService;

public class FileSystemGroupStoreFactory
implements IEntityGroupStoreFactory,
IEntityStoreFactory {
    protected static FileSystemGroupStore getGroupStore() throws GroupsException {
        return new FileSystemGroupStore();
    }

    public IEntityStore newEntityStore() throws GroupsException {
        try {
            return FileSystemGroupStoreFactory.getGroupStore();
        }
        catch (Exception ex) {
            LogService.log(LogService.ERROR, "FileSystemGroupStoreFactory.newEntityStore(): " + ex);
            throw new GroupsException(ex.getMessage());
        }
    }

    public IEntityGroupStore newGroupStore() throws GroupsException {
        return this.newGroupStore(null);
    }

    public IEntityGroupStore newGroupStore(ComponentGroupServiceDescriptor svcDescriptor) throws GroupsException {
        try {
            FileSystemGroupStore fsGroupStore = FileSystemGroupStoreFactory.getGroupStore();
            String groupsRoot = (String)svcDescriptor.get("groupsRoot");
            if (groupsRoot != null) {
                fsGroupStore.setGroupsRootPath(groupsRoot);
            }
            return fsGroupStore;
        }
        catch (Exception ex) {
            LogService.log(LogService.ERROR, "FileSystemGroupStoreFactory.newGroupStore(): " + ex);
            throw new GroupsException(ex.getMessage());
        }
    }
}

