/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.groups.EntityGroupImpl;
import org.jasig.portal.groups.EntityImpl;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityGroupStore;
import org.jasig.portal.groups.IEntitySearcher;
import org.jasig.portal.groups.IEntityStore;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.SmartCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LDAPGroupStore
implements IEntityGroupStore,
IEntityStore,
IEntitySearcher {
    protected String url;
    protected String logonid;
    protected String logonpassword;
    protected String keyfield;
    protected String namefield;
    protected String usercontext = "";
    protected HashMap groups;
    protected SmartCache contexts;
    protected SmartCache personkeys;
    protected static Class iperson = class$org$jasig$portal$security$IPerson == null ? (class$org$jasig$portal$security$IPerson = LDAPGroupStore.class$("org.jasig.portal.security.IPerson")) : class$org$jasig$portal$security$IPerson;
    protected static Class group = class$org$jasig$portal$groups$IEntityGroup == null ? (class$org$jasig$portal$groups$IEntityGroup = LDAPGroupStore.class$("org.jasig.portal.groups.IEntityGroup")) : class$org$jasig$portal$groups$IEntityGroup;
    protected static short ELEMENT_NODE = 1;
    static /* synthetic */ Class class$org$jasig$portal$security$IPerson;
    static /* synthetic */ Class class$org$jasig$portal$groups$IEntityGroup;

    public LDAPGroupStore() {
        Document config = null;
        try {
            config = ResourceLoader.getResourceAsDocument(this.getClass(), "/properties/groups/LDAPGroupStoreConfig.xml");
        }
        catch (Exception rme) {
            throw new RuntimeException("LDAPGroupStore: Unable to find configuration configuration document");
        }
        this.init(config);
    }

    public LDAPGroupStore(Document config) {
        this.init(config);
    }

    protected void init(Document config) {
        this.groups = new HashMap();
        this.contexts = new SmartCache(120);
        config.normalize();
        int refreshminutes = 120;
        Element root = config.getDocumentElement();
        NodeList nl = root.getElementsByTagName("config");
        if (nl.getLength() == 1) {
            Element conf = (Element)nl.item(0);
            for (Node cc = conf.getFirstChild(); cc != null; cc = cc.getNextSibling()) {
                if (cc.getNodeType() != ELEMENT_NODE) continue;
                Element c = (Element)cc;
                c.normalize();
                Node t = c.getFirstChild();
                if (t == null || t.getNodeType() != 3) continue;
                String name = c.getNodeName();
                String text = ((Text)t).getData();
                if (name.equals("url")) {
                    this.url = text;
                    continue;
                }
                if (name.equals("logonid")) {
                    this.logonid = text;
                    continue;
                }
                if (name.equals("logonpassword")) {
                    this.logonpassword = text;
                    continue;
                }
                if (name.equals("keyfield")) {
                    this.keyfield = text;
                    continue;
                }
                if (name.equals("namefield")) {
                    this.namefield = text;
                    continue;
                }
                if (name.equals("usercontext")) {
                    this.usercontext = text;
                    continue;
                }
                if (!name.equals("refresh-minutes")) continue;
                try {
                    refreshminutes = Integer.parseInt(text);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        } else {
            throw new RuntimeException("LDAPGroupStore: config file must contain one config element");
        }
        this.personkeys = new SmartCache(refreshminutes * 60);
        NodeList gl = root.getChildNodes();
        for (int j = 0; j < gl.getLength(); ++j) {
            Element g;
            if (gl.item(j).getNodeType() != ELEMENT_NODE || !(g = (Element)gl.item(j)).getNodeName().equals("group")) continue;
            GroupShadow shadow = this.processXmlGroupRecursive(g);
            this.groups.put(shadow.key, shadow);
        }
    }

    protected String[] getPersonKeys(String groupKey) {
        String[] r = (String[])this.personkeys.get(groupKey);
        if (r == null) {
            GroupShadow shadow = (GroupShadow)this.groups.get(groupKey);
            r = shadow.entities != null ? shadow.entities.getPersonKeys() : new String[]{};
            this.personkeys.put(groupKey, r);
        }
        return r;
    }

    protected GroupShadow processXmlGroupRecursive(Element groupElem) {
        GroupShadow shadow = new GroupShadow();
        shadow.key = groupElem.getAttribute("key");
        shadow.name = groupElem.getAttribute("name");
        ArrayList<GroupShadow> subgroups = new ArrayList<GroupShadow>();
        NodeList nl = groupElem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != ELEMENT_NODE) continue;
            Element e = (Element)nl.item(i);
            if (e.getNodeName().equals("group")) {
                GroupShadow sub = this.processXmlGroupRecursive(e);
                subgroups.add(sub);
                this.groups.put(sub.key, sub);
                continue;
            }
            if (e.getNodeName().equals("entity-set")) {
                shadow.entities = new EntitySet(e);
                continue;
            }
            if (!e.getNodeName().equals("description")) continue;
            e.normalize();
            Text t = (Text)e.getFirstChild();
            if (t == null) continue;
            shadow.description = t.getData();
        }
        shadow.subgroups = subgroups.toArray(new GroupShadow[0]);
        return shadow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processLdapResults(NamingEnumeration results, ArrayList keys) {
        try {
            while (results.hasMore()) {
                SearchResult result = (SearchResult)results.next();
                Attributes ldapattribs = result.getAttributes();
                Attribute attrib = ldapattribs.get(this.keyfield);
                if (attrib == null) continue;
                keys.add(String.valueOf(attrib.get()));
            }
        }
        catch (NamingException nex) {
            LogService.log(LogService.ERROR, "LDAPGroupStore: error processing results");
            LogService.log(LogService.ERROR, nex);
        }
        finally {
            try {
                results.close();
            }
            catch (Exception exception) {}
        }
    }

    protected DirContext getConnection() {
        DirContext context = (DirContext)this.contexts.get("context");
        if (context == null) {
            Hashtable<String, String> jndienv = new Hashtable<String, String>();
            jndienv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            jndienv.put("java.naming.security.authentication", "simple");
            jndienv.put("java.naming.provider.url", this.url);
            if (this.logonid != null) {
                jndienv.put("java.naming.security.principal", this.logonid);
            }
            if (this.logonpassword != null) {
                jndienv.put("java.naming.security.credentials", this.logonpassword);
            }
            try {
                context = new InitialDirContext(jndienv);
            }
            catch (NamingException nex) {
                LogService.log(LogService.ERROR, "LDAPGroupStore: unable to get context");
                LogService.log(LogService.ERROR, nex);
            }
            this.contexts.put("context", context);
        }
        return context;
    }

    protected IEntityGroup makeGroup(GroupShadow shadow) throws GroupsException {
        EntityGroupImpl group = null;
        if (shadow != null) {
            group = new EntityGroupImpl(shadow.key, iperson);
            group.setDescription(shadow.description);
            group.setName(shadow.name);
        }
        return group;
    }

    protected GroupShadow getShadow(IEntityGroup group) {
        return (GroupShadow)this.groups.get(group.getLocalKey());
    }

    public void delete(IEntityGroup group) throws GroupsException {
        throw new UnsupportedOperationException("LDAPGroupStore: Method delete() not supported.");
    }

    public IEntityGroup find(String key) throws GroupsException {
        return this.makeGroup((GroupShadow)this.groups.get(key));
    }

    public Iterator findContainingGroups(IGroupMember gm) throws GroupsException {
        int i;
        String key;
        ArrayList<IEntityGroup> al = new ArrayList<IEntityGroup>();
        GroupShadow[] shadows = this.getGroupShadows();
        if (gm.isEntity()) {
            key = gm.getKey();
            block0: for (i = 0; i < shadows.length; ++i) {
                String[] keys = this.getPersonKeys(shadows[i].key);
                for (int j = 0; j < keys.length; ++j) {
                    if (!keys[j].equals(key)) continue;
                    al.add(this.makeGroup(shadows[i]));
                    continue block0;
                }
            }
        }
        if (gm.isGroup()) {
            key = ((IEntityGroup)gm).getLocalKey();
            block2: for (i = 0; i < shadows.length; ++i) {
                for (int j = 0; j < shadows[i].subgroups.length; ++j) {
                    if (!shadows[i].subgroups[j].key.equals(key)) continue;
                    al.add(this.makeGroup(shadows[i]));
                    continue block2;
                }
            }
        }
        return al.iterator();
    }

    public String[] findMemberGroupKeys(IEntityGroup group) throws GroupsException {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator itr = this.findMemberGroups(group);
        while (itr.hasNext()) {
            IEntityGroup eg = (IEntityGroup)itr.next();
            keys.add(eg.getKey());
        }
        return keys.toArray(new String[keys.size()]);
    }

    public Iterator findMemberGroups(IEntityGroup group) throws GroupsException {
        ArrayList<IEntityGroup> al = new ArrayList<IEntityGroup>();
        GroupShadow shadow = this.getShadow(group);
        for (int i = 0; i < shadow.subgroups.length; ++i) {
            al.add(this.makeGroup(shadow.subgroups[i]));
        }
        return al.iterator();
    }

    public IEntityGroup newInstance(Class entityType) throws GroupsException {
        throw new UnsupportedOperationException("LDAPGroupStore: Method newInstance() not supported");
    }

    public void update(IEntityGroup group) throws GroupsException {
        throw new UnsupportedOperationException("LDAPGroupStore: Method update() not supported");
    }

    public void updateMembers(IEntityGroup group) throws GroupsException {
        throw new UnsupportedOperationException("LDAPGroupStore: Method updateMembers() not supported");
    }

    public ILockableEntityGroup findLockable(String key) throws GroupsException {
        throw new UnsupportedOperationException("LDAPGroupStore: Method findLockable() not supported");
    }

    protected GroupShadow[] getGroupShadows() {
        return this.groups.values().toArray(new GroupShadow[0]);
    }

    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype) throws GroupsException {
        ArrayList<EntityIdentifier> ids = new ArrayList<EntityIdentifier>();
        GroupShadow[] g = this.getGroupShadows();
        switch (method) {
            case 1: {
                for (int i = 0; i < g.length; ++i) {
                    if (!g[i].name.equals(query)) continue;
                    ids.add(new EntityIdentifier(g[i].key, group));
                }
                break;
            }
            case 2: {
                for (int i = 0; i < g.length; ++i) {
                    if (!g[i].name.startsWith(query)) continue;
                    ids.add(new EntityIdentifier(g[i].key, group));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < g.length; ++i) {
                    if (!g[i].name.endsWith(query)) continue;
                    ids.add(new EntityIdentifier(g[i].key, group));
                }
                break;
            }
            case 4: {
                for (int i = 0; i < g.length; ++i) {
                    if (g[i].name.indexOf(query) <= -1) continue;
                    ids.add(new EntityIdentifier(g[i].key, group));
                }
                break;
            }
        }
        return ids.toArray(new EntityIdentifier[0]);
    }

    public Iterator findEntitiesForGroup(IEntityGroup group) throws GroupsException {
        GroupShadow shadow = this.getShadow(group);
        ArrayList<EntityImpl> al = new ArrayList<EntityImpl>();
        String[] keys = this.getPersonKeys(shadow.key);
        for (int i = 0; i < keys.length; ++i) {
            al.add(new EntityImpl(keys[i], iperson));
        }
        return al.iterator();
    }

    public IEntity newInstance(String key) throws GroupsException {
        return new EntityImpl(key, null);
    }

    public IEntity newInstance(String key, Class type) throws GroupsException {
        if (EntityTypes.getEntityTypeID(type) == null) {
            throw new GroupsException("Invalid group type: " + type);
        }
        return new EntityImpl(key, type);
    }

    public EntityIdentifier[] searchForEntities(String query, int method, Class type) throws GroupsException {
        if (type != group && type != iperson) {
            return new EntityIdentifier[0];
        }
        ArrayList<EntityIdentifier> ids = new ArrayList<EntityIdentifier>();
        switch (method) {
            case 2: {
                query = query + "*";
                break;
            }
            case 3: {
                query = "*" + query;
                break;
            }
            case 4: {
                query = "*" + query + "*";
            }
        }
        query = this.namefield + "=" + query;
        DirContext context = this.getConnection();
        NamingEnumeration<SearchResult> userlist = null;
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        sc.setReturningAttributes(new String[]{this.keyfield});
        try {
            userlist = context.search(this.usercontext, query, sc);
        }
        catch (NamingException nex) {
            LogService.log(LogService.ERROR, "LDAPGroupStore: Unable to perform filter " + query);
            LogService.log(LogService.ERROR, nex);
        }
        ArrayList keys = new ArrayList();
        this.processLdapResults(userlist, keys);
        String[] k = keys.toArray(new String[0]);
        for (int i = 0; i < k.length; ++i) {
            ids.add(new EntityIdentifier(k[i], iperson));
        }
        return ids.toArray(new EntityIdentifier[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class EntitySet {
        public static final int FILTER = 1;
        public static final int UNION = 2;
        public static final int DIFFERENCE = 3;
        public static final int INTERSECTION = 4;
        public static final int SUBTRACT = 5;
        public static final int ATTRIBUTES = 6;
        protected int type;
        protected String filter;
        protected Attributes attributes;
        protected EntitySet[] subsets;

        protected EntitySet(Element entityset) {
            entityset.normalize();
            Node n = entityset.getFirstChild();
            while (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            Element e = (Element)n;
            String type = e.getNodeName();
            boolean collectSubsets = false;
            if (type.equals("filter")) {
                this.type = 1;
                this.filter = e.getAttribute("string");
            } else if (type.equals("attributes")) {
                this.type = 6;
                this.attributes = new BasicAttributes();
                NodeList atts = e.getChildNodes();
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (atts.item(i).getNodeType() != ELEMENT_NODE) continue;
                    Element a = (Element)atts.item(i);
                    this.attributes.put(a.getAttribute("name"), a.getAttribute("value"));
                }
            } else if (type.equals("union")) {
                this.type = 2;
                collectSubsets = true;
            } else if (type.equals("intersection")) {
                this.type = 4;
                collectSubsets = true;
            } else if (type.equals("difference")) {
                this.type = 3;
                collectSubsets = true;
            } else if (type.equals("subtract")) {
                this.type = 5;
                collectSubsets = true;
            }
            if (collectSubsets) {
                ArrayList<EntitySet> subs = new ArrayList<EntitySet>();
                NodeList nl = e.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    if (nl.item(i).getNodeType() != 1) continue;
                    EntitySet subset = new EntitySet((Element)nl.item(i));
                    subs.add(subset);
                }
                this.subsets = subs.toArray(new EntitySet[0]);
            }
        }

        protected String[] getPersonKeys() {
            ArrayList<String> keys = new ArrayList<String>();
            switch (this.type) {
                case 1: {
                    DirContext context = LDAPGroupStore.this.getConnection();
                    NamingEnumeration<SearchResult> userlist = null;
                    SearchControls sc = new SearchControls();
                    sc.setSearchScope(2);
                    sc.setReturningAttributes(new String[]{LDAPGroupStore.this.keyfield});
                    try {
                        userlist = context.search(LDAPGroupStore.this.usercontext, this.filter, sc);
                    }
                    catch (NamingException nex) {
                        LogService.log(LogService.ERROR, "LDAPGroupStore: Unable to perform filter " + this.filter);
                        LogService.log(LogService.ERROR, nex);
                    }
                    LDAPGroupStore.this.processLdapResults(userlist, keys);
                    break;
                }
                case 6: {
                    DirContext context2 = LDAPGroupStore.this.getConnection();
                    NamingEnumeration<SearchResult> userlist2 = null;
                    try {
                        userlist2 = context2.search(LDAPGroupStore.this.usercontext, this.attributes, new String[]{LDAPGroupStore.this.keyfield});
                    }
                    catch (NamingException nex) {
                        LogService.log(LogService.ERROR, "LDAPGroupStore: Unable to perform attribute search");
                        LogService.log(LogService.ERROR, nex);
                    }
                    LDAPGroupStore.this.processLdapResults(userlist2, keys);
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.subsets.length; ++i) {
                        String[] subkeys = this.subsets[i].getPersonKeys();
                        for (int j = 0; j < subkeys.length; ++j) {
                            String key = subkeys[j];
                            if (keys.contains(key)) continue;
                            keys.add(key);
                        }
                    }
                    break;
                }
                case 4: {
                    if (this.subsets.length <= 0) break;
                    String[] interkeys = this.subsets[0].getPersonKeys();
                    for (int m = 1; m < this.subsets.length; ++m) {
                        String[] subkeys = this.subsets[m].getPersonKeys();
                        for (int n = 0; n < interkeys.length; ++n) {
                            if (interkeys[n] == null) continue;
                            boolean remove = true;
                            for (int o = 0; o < subkeys.length; ++o) {
                                if (!subkeys[o].equals(interkeys[n])) continue;
                                remove = false;
                                break;
                            }
                            if (!remove) continue;
                            interkeys[n] = null;
                        }
                    }
                    for (int p = 0; p < interkeys.length; ++p) {
                        if (interkeys[p] == null) continue;
                        keys.add(interkeys[p]);
                    }
                    break;
                }
                case 3: {
                    if (this.subsets.length <= 0) break;
                    ArrayList<String> discardKeys = new ArrayList<String>();
                    String[] subkeys = this.subsets[0].getPersonKeys();
                    for (int q = 0; q < subkeys.length; ++q) {
                        keys.add(subkeys[q]);
                    }
                    for (int r = 1; r < this.subsets.length; ++r) {
                        subkeys = this.subsets[r].getPersonKeys();
                        for (int s = 0; s < subkeys.length; ++s) {
                            String ky = subkeys[s];
                            if (keys.contains(ky)) {
                                keys.remove(ky);
                                discardKeys.add(ky);
                                continue;
                            }
                            if (discardKeys.contains(ky)) continue;
                            keys.add(ky);
                        }
                    }
                    break;
                }
                case 5: {
                    if (this.subsets.length <= 0) break;
                    String[] subkeys = this.subsets[0].getPersonKeys();
                    for (int t = 0; t < subkeys.length; ++t) {
                        keys.add(subkeys[t]);
                    }
                    for (int u = 1; u < this.subsets.length; ++u) {
                        subkeys = this.subsets[u].getPersonKeys();
                        for (int v = 0; v < subkeys.length; ++v) {
                            String kyy = subkeys[v];
                            if (!keys.contains(kyy)) continue;
                            keys.remove(kyy);
                        }
                    }
                    break;
                }
            }
            return keys.toArray(new String[0]);
        }
    }

    protected class GroupShadow {
        protected String key;
        protected String name;
        protected String description;
        protected GroupShadow[] subgroups;
        protected EntitySet entities;

        protected GroupShadow() {
        }
    }
}

