/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.webservices;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.axis.MessageContext;
import org.apache.axis.session.Session;
import org.apache.axis.transport.http.HTTPConstants;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.ChannelDefinition;
import org.jasig.portal.ChannelFactory;
import org.jasig.portal.ChannelParameter;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.ChannelRendererFactory;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IChannel;
import org.jasig.portal.IChannelRenderer;
import org.jasig.portal.IChannelRendererFactory;
import org.jasig.portal.InternalTimeoutException;
import org.jasig.portal.MediaManager;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.services.Authentication;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.utils.AbsoluteURLFilter;
import org.jasig.portal.webservices.IRemoteChannel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;
import tyrex.naming.MemoryContext;

public class RemoteChannel
implements IRemoteChannel {
    private static final IChannelRendererFactory cChannelRendererFactory = ChannelRendererFactory.newInstance((class$org$jasig$portal$wsrp$ChannelInstanceManager == null ? (class$org$jasig$portal$wsrp$ChannelInstanceManager = RemoteChannel.class$("org.jasig.portal.wsrp.ChannelInstanceManager")) : class$org$jasig$portal$wsrp$ChannelInstanceManager).getName());
    protected static final String MARKUP_FRAGMENT_ROOT = "channel";
    protected static final String PERSON_KEY = "org.jasig.portal.security.IPerson";
    protected static final String CHANNEL_INSTANCE_ID_PREFIX = "chan_";
    protected static final String CHANNEL_DEFINITION_ID_PREFIX = "chandef_";
    protected static final Authentication authenticationService = new Authentication();
    protected static final Random randomNumberGenerator = new Random();
    protected static String baseUrl = null;
    static /* synthetic */ Class class$org$jasig$portal$wsrp$ChannelInstanceManager;

    public void authenticate(String username, String password) throws Exception {
        IPerson person = this.getPerson();
        HashMap<String, String> principals = new HashMap<String, String>(1);
        principals.put("root", username);
        HashMap<String, String> credentials = new HashMap<String, String>(1);
        credentials.put("root", password);
        authenticationService.authenticate(principals, credentials, person);
        if (!person.getSecurityContext().isAuthenticated()) {
            throw new PortalSecurityException("Unable to authenticate user '" + username + "'");
        }
    }

    public String instantiateChannel(String fname) throws Exception {
        int channelPublishId;
        MessageContext messageContext = MessageContext.getCurrentContext();
        Session session = messageContext.getSession();
        ChannelDefinition channelDef = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl().getChannelDefinition(fname);
        if (channelDef == null) {
            throw new ResourceMissingException("fname:" + fname, fname + " channel", "Unable to find a channel with functional name '" + fname + "'");
        }
        IPerson person = this.getPerson();
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        boolean authorized = ap.canSubscribe(channelPublishId = channelDef.getId());
        if (!authorized) {
            throw new AuthorizationException("User '" + person.getAttribute("username") + "' is not authorized to access channel with functional name '" + fname + "'");
        }
        String javaClass = channelDef.getJavaClass();
        String instanceId = Long.toHexString(randomNumberGenerator.nextLong()) + "_" + System.currentTimeMillis();
        String uid = messageContext.getProperty("SimpleSession.id") + "/" + instanceId;
        IChannel channel = ChannelFactory.instantiateChannel(javaClass, uid);
        ChannelStaticData staticData = new ChannelStaticData();
        staticData.setChannelPublishId(String.valueOf(channelPublishId));
        staticData.setPerson(person);
        staticData.setTimeout(channelDef.getTimeout());
        Hashtable<String, String> environment = new Hashtable<String, String>(1);
        environment.put("java.naming.factory.initial", "org.jasig.portal.jndi.PortalInitialContextFactory");
        InitialContext portalContext = new InitialContext(environment);
        MemoryContext channelContext = new MemoryContext(new Hashtable());
        Context servicesContext = (Context)portalContext.lookup("services");
        channelContext.bind("services", (Object)servicesContext);
        staticData.setJNDIContext((Context)channelContext);
        ChannelParameter[] channelParams = channelDef.getParameters();
        for (int i = 0; i < channelParams.length; ++i) {
            staticData.setParameter(channelParams[i].getName(), channelParams[i].getValue());
        }
        channel.setStaticData(staticData);
        session.set(CHANNEL_INSTANCE_ID_PREFIX + instanceId, (Object)channel);
        session.set(CHANNEL_DEFINITION_ID_PREFIX + instanceId, (Object)channelDef);
        return instanceId;
    }

    public Element renderChannel(String instanceId, ChannelRuntimeData runtimeData) throws Exception {
        Element channelElement = null;
        IChannel channel = null;
        ChannelDefinition channelDef = null;
        MessageContext messageContext = MessageContext.getCurrentContext();
        Session session = messageContext.getSession();
        channel = (IChannel)session.get(CHANNEL_INSTANCE_ID_PREFIX + instanceId);
        channelDef = (ChannelDefinition)session.get(CHANNEL_DEFINITION_ID_PREFIX + instanceId);
        if (channel == null || channelDef == null) {
            throw new ResourceMissingException("id:" + instanceId, instanceId + " channel", "Unable to find a channel with instance ID '" + instanceId + "'");
        }
        IChannelRenderer cr = cChannelRendererFactory.newInstance(channel, runtimeData);
        cr.setTimeout(channelDef.getTimeout());
        cr.startRendering();
        AttributesImpl chanAtts = new AttributesImpl();
        chanAtts.addAttribute("", "name", "name", "CDATA", channelDef.getName());
        chanAtts.addAttribute("", "title", "title", "CDATA", channelDef.getTitle());
        chanAtts.addAttribute("", "description", "description", "CDATA", channelDef.getDescription());
        chanAtts.addAttribute("", "hasAbout", "hasAbout", "CDATA", String.valueOf(channelDef.hasAbout()));
        chanAtts.addAttribute("", "hasHelp", "hasHelp", "CDATA", String.valueOf(channelDef.hasHelp()));
        chanAtts.addAttribute("", "editable", "editable", "CDATA", String.valueOf(channelDef.isEditable()));
        TransformerFactory tf = TransformerFactory.newInstance();
        SAXTransformerFactory stf = (SAXTransformerFactory)tf;
        TransformerHandler th = stf.newTransformerHandler();
        DOMResult domResult = new DOMResult();
        th.setResult(domResult);
        th.startDocument();
        th.startElement("", MARKUP_FRAGMENT_ROOT, MARKUP_FRAGMENT_ROOT, chanAtts);
        try {
            MediaManager mm = new MediaManager();
            String media = mm.getMedia(runtimeData.getBrowserInfo());
            String mimeType = mm.getReturnMimeType(media);
            AbsoluteURLFilter urlFilter = AbsoluteURLFilter.newAbsoluteURLFilter(mimeType, RemoteChannel.getBaseUrl(), th);
            int status = cr.outputRendering(urlFilter);
            if (status == 2) {
                throw new InternalTimeoutException("The remote channel has timed out");
            }
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new Exception(t.getMessage());
        }
        th.endElement("", MARKUP_FRAGMENT_ROOT, MARKUP_FRAGMENT_ROOT);
        th.endDocument();
        Document doc = (Document)domResult.getNode();
        channelElement = doc.getDocumentElement();
        return channelElement;
    }

    public void receiveEvent(String instanceId, PortalEvent event) throws Exception {
        MessageContext messageContext = MessageContext.getCurrentContext();
        Session session = messageContext.getSession();
        IChannel channel = (IChannel)session.get(CHANNEL_INSTANCE_ID_PREFIX + instanceId);
        if (channel == null) {
            throw new ResourceMissingException("id:" + instanceId, instanceId + " channel", "Unable to find a channel with instance ID '" + instanceId + "'");
        }
        channel.receiveEvent(event);
    }

    public void freeChannel(String instanceId) throws Exception {
        MessageContext messageContext = MessageContext.getCurrentContext();
        Session session = messageContext.getSession();
        session.remove(CHANNEL_DEFINITION_ID_PREFIX + instanceId);
        session.remove(CHANNEL_INSTANCE_ID_PREFIX + instanceId);
    }

    public void logout() throws Exception {
        MessageContext messageContext = MessageContext.getCurrentContext();
        messageContext.setSession(null);
    }

    protected IPerson getPerson() throws PortalException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        Session session = messageContext.getSession();
        IPerson person = (IPerson)session.get(PERSON_KEY);
        if (person == null) {
            person = this.getGuestPerson();
            session.set(PERSON_KEY, (Object)person);
        }
        return person;
    }

    protected IPerson getGuestPerson() throws PortalException {
        IPerson person = PersonFactory.createGuestPerson();
        return person;
    }

    protected static String getBaseUrl() {
        if (baseUrl == null) {
            MessageContext messageContext = MessageContext.getCurrentContext();
            HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            String protocol = request.getProtocol();
            String protocolFixed = protocol.substring(0, protocol.indexOf("/")).toLowerCase();
            String serverName = request.getServerName();
            int serverPort = request.getServerPort();
            String contextPath = request.getContextPath();
            baseUrl = protocolFixed + "://" + serverName + ":" + serverPort + contextPath + "/";
        }
        return baseUrl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

