/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.PortalException;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonManagerFactory;
import org.jasig.portal.services.Authentication;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.ResourceLoader;

public class LoginServlet
extends HttpServlet {
    private static final String redirectString;
    private static HashMap credentialTokens;
    private static HashMap principalTokens;
    private Authentication m_authenticationService = null;
    static /* synthetic */ Class class$org$jasig$portal$LoginServlet;

    public void init() throws ServletException {
        this.m_authenticationService = new Authentication();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.getSession().invalidate();
        request.getSession(true);
        IPerson person = null;
        try {
            person = PersonManagerFactory.getPersonManagerInstance().getPerson(request);
            HashMap principals = this.getPropertyFromRequest(principalTokens, request);
            HashMap credentials = this.getPropertyFromRequest(credentialTokens, request);
            this.m_authenticationService.authenticate(principals, credentials, person);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
            person = null;
            request.getSession(false).invalidate();
            request.getSession(true).setAttribute("up_authenticationError", (Object)"true");
        }
        if (person != null && person.getSecurityContext().isAuthenticated()) {
            response.sendRedirect(request.getContextPath() + '/' + redirectString);
        } else {
            request.getSession(false).setAttribute("up_authenticationAttempted", (Object)"true");
            String attemptedUserName = request.getParameter("userName");
            if (attemptedUserName != null) {
                request.getSession(false).setAttribute("up_attemptedUserName", (Object)request.getParameter("userName"));
            }
            response.sendRedirect(request.getContextPath() + '/' + redirectString);
        }
    }

    private HashMap getPropertyFromRequest(HashMap tokens, HttpServletRequest request) {
        HashMap<String, String> retHash = new HashMap<String, String>(1);
        Iterator tokenItr = tokens.keySet().iterator();
        while (tokenItr.hasNext()) {
            String ctxName = (String)tokenItr.next();
            String parmName = (String)tokens.get(ctxName);
            String parmValue = request.getParameter(parmName);
            parmValue = (parmValue == null ? "" : parmValue).trim();
            String key = ctxName.startsWith("root.") ? ctxName.substring(5) : ctxName;
            retHash.put(key, parmValue);
        }
        return retHash;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String upFile = "render.userLayoutRootNode.uP";
        HashMap<String, String> cHash = new HashMap<String, String>(1);
        HashMap<String, String> pHash = new HashMap<String, String>(1);
        try {
            upFile = UPFileSpec.buildUPFile(null, 0, "userLayoutRootNode", null, null);
            Properties props = ResourceLoader.getResourceAsProperties(class$org$jasig$portal$LoginServlet == null ? (class$org$jasig$portal$LoginServlet = LoginServlet.class$("org.jasig.portal.LoginServlet")) : class$org$jasig$portal$LoginServlet, "/properties/security.properties");
            Enumeration<?> propNames = props.propertyNames();
            while (propNames.hasMoreElements()) {
                String key;
                String propName = (String)propNames.nextElement();
                String propValue = props.getProperty(propName);
                if (propName.startsWith("credentialToken.")) {
                    key = propName.substring(16);
                    cHash.put(key, propValue);
                }
                if (!propName.startsWith("principalToken.")) continue;
                key = propName.substring(15);
                pHash.put(key, propValue);
            }
        }
        catch (PortalException pe) {
            LogService.log(LogService.ERROR, "LoginServlet::static " + pe);
        }
        catch (IOException ioe) {
            LogService.log(LogService.ERROR, "LoginServlet::static " + ioe);
        }
        redirectString = upFile;
        credentialTokens = cHash;
        principalTokens = pHash;
    }
}

