/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.util.Properties;
import org.jasig.portal.services.LogService;

public class PropertiesManager {
    private static final String PORTAL_PROPERTIES_FILE_NAME = "/properties/portal.properties";
    private static final Properties props = new Properties();
    static /* synthetic */ Class class$org$jasig$portal$PropertiesManager;

    protected static void loadProps() {
        try {
            props.load((class$org$jasig$portal$PropertiesManager == null ? (class$org$jasig$portal$PropertiesManager = PropertiesManager.class$("org.jasig.portal.PropertiesManager")) : class$org$jasig$portal$PropertiesManager).getResourceAsStream(PORTAL_PROPERTIES_FILE_NAME));
        }
        catch (IOException ioe) {
            LogService.log(LogService.ERROR, "Unable to read portal.properties file.");
            LogService.log(LogService.ERROR, ioe);
        }
    }

    public static String getProperty(String name) {
        String val = PropertiesManager.getPropertyUntrimmed(name);
        return val.trim();
    }

    public static String getPropertyUntrimmed(String name) {
        String val = props.getProperty(name);
        if (val == null) {
            throw new RuntimeException("Property " + name + " not found!");
        }
        return val;
    }

    public static boolean getPropertyAsBoolean(String name) {
        boolean retValue = false;
        String value = PropertiesManager.getProperty(name);
        if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("y") || value.equalsIgnoreCase("on"))) {
            retValue = true;
        }
        return retValue;
    }

    public static byte getPropertyAsByte(String name) {
        return Byte.parseByte(PropertiesManager.getProperty(name));
    }

    public static short getPropertyAsShort(String name) {
        return Short.parseShort(PropertiesManager.getProperty(name));
    }

    public static int getPropertyAsInt(String name) {
        return Integer.parseInt(PropertiesManager.getProperty(name));
    }

    public static long getPropertyAsLong(String name) {
        return Long.parseLong(PropertiesManager.getProperty(name));
    }

    public static float getPropertyAsFloat(String name) {
        return Float.parseFloat(PropertiesManager.getProperty(name));
    }

    public static double getPropertyAsDouble(String name) {
        return Double.parseDouble(PropertiesManager.getProperty(name));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PropertiesManager.loadProps();
    }
}

