/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.w3c.dom.ProcessingInstruction;

public class StylesheetDescription {
    public String s_href;
    public String s_type;
    public String s_title;
    public String s_media;
    public String s_charset;
    public boolean b_alternate;

    public StylesheetDescription() {
    }

    public StylesheetDescription(String uri, String type) {
        this.s_href = uri;
        this.s_type = type;
        this.s_media = new String("");
        this.s_charset = null;
        this.b_alternate = false;
        this.s_title = new String("");
    }

    public StylesheetDescription(String uri, String type, String title, String media, String charset, boolean alternate) {
        this.s_href = uri;
        this.s_type = type;
        this.s_media = media;
        this.s_charset = charset;
        this.b_alternate = alternate;
        this.s_title = title;
    }

    public StylesheetDescription(ProcessingInstruction pi) {
        if (pi.getNodeName().equals("xml-stylesheet")) {
            PIAttributes pia = new PIAttributes(pi);
            this.s_href = pia.getAttribute("href");
            this.s_type = pia.getAttribute("type");
            this.s_title = pia.getAttribute("title");
            this.s_media = pia.getAttribute("media");
            this.s_charset = pia.getAttribute("charset");
            this.b_alternate = "yes".equals(pia.getAttribute("alternate"));
            if (this.s_media == null) {
                this.s_media = new String("");
            }
            if (this.s_title == null) {
                this.s_title = new String("");
            }
        }
    }

    public StylesheetDescription(String data) {
        PIAttributes pia = new PIAttributes(data);
        this.s_href = pia.getAttribute("href");
        this.s_type = pia.getAttribute("type");
        this.s_title = pia.getAttribute("title");
        this.s_media = pia.getAttribute("media");
        this.s_charset = pia.getAttribute("charset");
        this.b_alternate = "yes".equals(pia.getAttribute("alternate"));
        if (this.s_media == null) {
            this.s_media = new String("");
        }
        if (this.s_title == null) {
            this.s_title = new String("");
        }
    }

    public String getTitle() {
        return this.s_title;
    }

    public String getURI() {
        return this.s_href;
    }

    public String getType() {
        return this.s_type;
    }

    public String getMedia() {
        return this.s_media;
    }

    public boolean getAlternate() {
        return this.b_alternate;
    }

    public String getCharset() {
        return this.s_charset;
    }

    public void setTitle(String title) {
        this.s_title = title;
    }

    public void setType(String type) {
        this.s_type = type;
    }

    public void setMedia(String media) {
        this.s_media = media;
    }

    public void setURI(String uri) {
        this.s_href = uri;
    }

    public void setCharset(String charset) {
        this.s_charset = charset;
    }

    public void setAlternate(boolean alternate) {
        this.b_alternate = alternate;
    }

    class PIAttributes {
        private Hashtable piAttributes = new Hashtable();

        PIAttributes(String data) {
            StringTokenizer tokenizer = new StringTokenizer(data, "=\"");
            while (tokenizer.hasMoreTokens()) {
                this.piAttributes.put(tokenizer.nextToken().trim(), tokenizer.nextToken().trim());
            }
        }

        PIAttributes(ProcessingInstruction pi) {
            this(pi.getNodeValue());
        }

        String getAttribute(String name) {
            return (String)this.piAttributes.get(name);
        }
    }
}

