/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.groupsmanager;

import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.groupsmanager.CGroupsManager;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerServant;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerUnrestrictedSessionData;
import org.jasig.portal.channels.groupsmanager.GroupsManagerConstants;
import org.jasig.portal.channels.groupsmanager.GroupsManagerXML;
import org.jasig.portal.channels.groupsmanager.IGroupsManagerPermissions;
import org.jasig.portal.channels.groupsmanager.Utility;
import org.jasig.portal.channels.groupsmanager.permissions.GroupsManagerBlockEntitySelectPermissions;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.services.GroupService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CGroupsManagerServantFactory
implements GroupsManagerConstants {
    private static CGroupsManagerServantFactory _instance;
    private static int UID;
    private HashMap servantClasses = new HashMap();
    private static CGroupsManager _groupsManager;

    protected CGroupsManagerServantFactory() {
    }

    protected static CGroupsManagerServant getGroupsServant() {
        return new CGroupsManagerServant(_groupsManager, CGroupsManagerServantFactory.getNextUid());
    }

    public static IServant getGroupsServantforSelection(ChannelStaticData staticData, String message) throws PortalException {
        return CGroupsManagerServantFactory.getGroupsServantforSelection(staticData, message, null);
    }

    public static IServant getGroupsServantforSelection(ChannelStaticData staticData, String message, String type, boolean allowFinish, boolean allowEntitySelect, IGroupMember[] members) throws PortalException {
        return CGroupsManagerServantFactory.getGroupsServantforSelection(staticData, message, type, allowFinish, allowEntitySelect, members, null);
    }

    public static IServant getGroupsServantforGroupMemberships(ChannelStaticData staticData, String message, IGroupMember member, boolean allowFinish) throws PortalException {
        CGroupsManagerServant servant = null;
        String typeKey = null;
        try {
            typeKey = GroupService.getRootGroup(member.getType()).getKey();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            servant = CGroupsManagerServantFactory.getGroupsServant();
            ChannelStaticData slaveSD = CGroupsManagerServantFactory.cloneStaticData(staticData);
            servant.setStaticData(slaveSD);
            if (typeKey != null) {
                servant.getSessionData().rootViewGroupID = Utility.translateKeytoID(typeKey, servant.getSessionData().getUnrestrictedData());
            }
            servant.getSessionData().highlightedGroupID = servant.getSessionData().rootViewGroupID;
            servant.getSessionData().mode = "select";
            servant.getSessionData().allowFinish = allowFinish;
            servant.getSessionData().gmPermissions = GroupsManagerBlockEntitySelectPermissions.getInstance();
            if (message != null) {
                servant.getSessionData().customMessage = message;
            }
            CGroupsManagerUnrestrictedSessionData ursd = servant.getSessionData().getUnrestrictedData();
            Document viewDoc = servant.getSessionData().model;
            Element rootElem = viewDoc.getDocumentElement();
            try {
                Iterator parents = member.getContainingGroups();
                while (parents.hasNext()) {
                    IEntityGroup parent = (IEntityGroup)parents.next();
                    Element parentElem = GroupsManagerXML.getGroupMemberXml(parent, false, null, ursd);
                    parentElem.setAttribute("selected", "true");
                    rootElem.appendChild(parentElem);
                }
            }
            catch (Exception e) {
                Utility.logMessage("ERROR", e.toString(), e);
            }
        }
        catch (Exception e) {
            throw new PortalException("CGroupsManagerServantFactory - unable to initialize servant");
        }
        return servant;
    }

    public static IServant getGroupsServantforSelection(ChannelStaticData staticData, String message, String type) throws PortalException {
        return CGroupsManagerServantFactory.getGroupsServantforSelection(staticData, message, type, true, true);
    }

    public static IServant getGroupsServantforSelection(ChannelStaticData staticData, String message, String type, boolean allowFinish, boolean allowEntitySelect) throws PortalException {
        return CGroupsManagerServantFactory.getGroupsServantforSelection(staticData, message, type, allowFinish, allowEntitySelect, new IGroupMember[0]);
    }

    public static IServant getGroupsServantforAddRemove(ChannelStaticData staticData, String groupKey) throws PortalException {
        CGroupsManagerServant servant;
        long time1 = Calendar.getInstance().getTime().getTime();
        try {
            ILockableEntityGroup lockedGroup = GroupService.findLockableGroup(groupKey, staticData.getAuthorizationPrincipal().getPrincipalString());
            lockedGroup.getClass();
            servant = CGroupsManagerServantFactory.getGroupsServant();
            ChannelStaticData slaveSD = CGroupsManagerServantFactory.cloneStaticData(staticData);
            servant.setStaticData(slaveSD);
            servant.getSessionData().mode = "members";
            servant.getSessionData().lockedGroup = lockedGroup;
            servant.getSessionData().highlightedGroupID = Utility.translateKeytoID(groupKey, servant.getSessionData().getUnrestrictedData());
            servant.getSessionData().defaultRootViewGroupID = Utility.translateKeytoID(groupKey, servant.getSessionData().getUnrestrictedData());
        }
        catch (Exception e) {
            Utility.logMessage("ERROR", e.toString(), e);
            throw new PortalException("CGroupsManagerServantFactory - unable to initialize servant");
        }
        long time2 = Calendar.getInstance().getTime().getTime();
        Utility.logMessage("INFO", "CGroupsManagerFactory took  " + String.valueOf(time2 - time1) + " ms to instantiate add/remove servant");
        return servant;
    }

    protected static ChannelStaticData cloneStaticData(ChannelStaticData sd) {
        ChannelStaticData rsd = (ChannelStaticData)sd.clone();
        Enumeration srd = rsd.keys();
        while (srd.hasMoreElements()) {
            rsd.remove(srd.nextElement());
        }
        return rsd;
    }

    protected static synchronized CGroupsManagerServantFactory instance() {
        if (_instance == null) {
            _instance = new CGroupsManagerServantFactory();
        }
        return _instance;
    }

    public static synchronized String getNextUid() {
        Utility.logMessage("DEBUG", "GroupsManagerXML::getNextUid(): Start");
        if (UID > 2147483600) {
            UID = 0;
        }
        String newUid = Calendar.getInstance().getTime().getTime() + "grpsservant" + ++UID;
        return newUid;
    }

    public static IServant getGroupsServantforSelection(ChannelStaticData staticData, String message, String type, boolean allowFinish, boolean allowEntitySelect, IGroupMember[] members, IGroupsManagerPermissions permissions) throws PortalException {
        CGroupsManagerServant servant;
        long time1;
        block13: {
            time1 = System.currentTimeMillis();
            try {
                servant = CGroupsManagerServantFactory.getGroupsServant();
                ChannelStaticData slaveSD = CGroupsManagerServantFactory.cloneStaticData(staticData);
                Utility.logMessage("DEBUG", "CGroupsManagerFactory::getGroupsServantforSelection: slaveSD before setting servant static data: " + slaveSD);
                servant.setStaticData(slaveSD);
                servant.getSessionData().mode = "select";
                servant.getSessionData().allowFinish = allowFinish;
                if (permissions != null) {
                    servant.getSessionData().gmPermissions = permissions;
                } else if (!allowEntitySelect) {
                    servant.getSessionData().gmPermissions = GroupsManagerBlockEntitySelectPermissions.getInstance();
                }
                if (message != null) {
                    servant.getSessionData().customMessage = message;
                }
                String typeKey = null;
                if (type != null && !type.equals("")) {
                    try {
                        typeKey = GroupService.getDistinguishedGroup(type).getKey();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (typeKey != null) {
                    servant.getSessionData().rootViewGroupID = Utility.translateKeytoID(typeKey, servant.getSessionData().getUnrestrictedData());
                }
                servant.getSessionData().highlightedGroupID = servant.getSessionData().rootViewGroupID;
                if (members == null || members.length <= 0) break block13;
                Document viewDoc = servant.getSessionData().model;
                CGroupsManagerUnrestrictedSessionData ursd = servant.getSessionData().getUnrestrictedData();
                Element rootElem = viewDoc.getDocumentElement();
                try {
                    for (int mm = 0; mm < members.length; ++mm) {
                        IGroupMember mem = members[mm];
                        Element memelem = GroupsManagerXML.getGroupMemberXml(mem, false, null, ursd);
                        memelem.setAttribute("selected", "true");
                        rootElem.appendChild(memelem);
                    }
                }
                catch (Exception e) {
                    Utility.logMessage("ERROR", e.toString(), e);
                }
            }
            catch (Exception e) {
                Utility.logMessage("ERROR", e.toString(), e);
                throw new PortalException("CGroupsManagerServantFactory - unable to initialize servant");
            }
        }
        long time2 = System.currentTimeMillis();
        Utility.logMessage("INFO", "CGroupsManagerFactory took  " + String.valueOf(time2 - time1) + " ms to instantiate selection servant");
        return servant;
    }

    static {
        UID = 0;
        _groupsManager = new CGroupsManager();
    }
}

