/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.caching;

import java.util.HashMap;

public class LRUCache
extends HashMap {
    protected static int DEFAULT_MAX_SIZE = 1000;
    protected int maxSize;
    protected static int DEFAULT_MAX_UNUSED_TIME_MILLIS = 1800000;
    protected int maxUnusedTimeMillis;

    public LRUCache() {
        this(DEFAULT_MAX_SIZE, DEFAULT_MAX_UNUSED_TIME_MILLIS);
    }

    public LRUCache(int size) {
        this(size, DEFAULT_MAX_UNUSED_TIME_MILLIS);
    }

    public LRUCache(int size, int maxUnusedAge) {
        this.maxSize = size;
        this.maxUnusedTimeMillis = maxUnusedAge;
    }

    public synchronized void clear() {
        super.clear();
    }

    public synchronized Object get(Object key) {
        ValueWrapper valueWrapper = (ValueWrapper)super.get(key);
        if (valueWrapper != null) {
            valueWrapper.resetLastReferenceTime();
            return valueWrapper.getValue();
        }
        return null;
    }

    public synchronized Object put(Object key, Object value) {
        ValueWrapper valueWrapper = new ValueWrapper(value);
        return super.put(key, valueWrapper);
    }

    public synchronized Object remove(Object key) {
        return super.remove(key);
    }

    public void sweepCache() {
        long now = System.currentTimeMillis();
        long maxAge = this.maxUnusedTimeMillis;
        while (this.size() > this.maxSize) {
            long cutOff = now - maxAge;
            Object[] keys = this.getKeySetArray();
            for (int i = 0; i < keys.length; ++i) {
                ValueWrapper valueWrapper = (ValueWrapper)super.get(keys[i]);
                if (valueWrapper == null || valueWrapper.getLastReferenceTime() >= cutOff) continue;
                this.remove(keys[i]);
            }
            maxAge = maxAge * 3L / 4L;
        }
    }

    private synchronized Object[] getKeySetArray() {
        return this.keySet().toArray(new Object[this.size()]);
    }

    private class ValueWrapper {
        private long lastReferenceTime = System.currentTimeMillis();
        private Object oValue;

        protected ValueWrapper(Object oValue) {
            this.oValue = oValue;
        }

        protected Object getValue() {
            return this.oValue;
        }

        protected void setValue(Object oValue) {
            this.oValue = oValue;
        }

        protected long getLastReferenceTime() {
            return this.lastReferenceTime;
        }

        protected void resetLastReferenceTime() {
            this.lastReferenceTime = System.currentTimeMillis();
        }
    }
}

