/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.threading;

import org.jasig.portal.utils.threading.Queue;
import org.jasig.portal.utils.threading.ThreadPool;
import org.jasig.portal.utils.threading.WorkTracker;
import org.jasig.portal.utils.threading.WorkerTask;

public final class Worker
extends Thread {
    private ThreadPool pool;
    private Queue work;
    private WorkerTask task;
    private WorkTracker tracker;
    private boolean continueWorking;
    private static int iThreadID = 0;

    public Worker(ThreadPool pool, Queue work) {
        this.pool = pool;
        this.work = work;
        this.continueWorking = true;
        this.setName("uPortal thread pool worker #" + ++iThreadID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.continueWorking) {
            try {
                this.task = (WorkerTask)this.work.take();
                this.pool.lockThread(this);
                this.task.setWorker(this);
                this.tracker = this.task.getWorkTracker();
                if (this.tracker.getState() != 3) {
                    this.tracker.updateStatus(1, false, null);
                    this.task.run();
                    if (this.task.hasException()) {
                        this.tracker.updateStatus(2, false, this.task.getException());
                    } else {
                        this.tracker.updateStatus(2, true, null);
                    }
                }
                this.cleanState();
                this.pool.releaseThread(this);
            }
            catch (Exception ie) {
                if (this.tracker != null) {
                    this.tracker.updateStatus(3, false, null);
                    this.cleanState();
                }
                Worker.interrupted();
            }
            finally {
                Thread.yield();
            }
        }
    }

    public void stopWorker() {
        this.continueWorking = false;
        if (!this.isInterrupted()) {
            this.interrupt();
        }
        this.pool.destroyThread(this);
    }

    private void cleanState() {
        if (this.tracker != null) {
            this.tracker.deregisterWork();
            this.task.deregisterTracker();
        }
        this.tracker = null;
        this.task = null;
    }
}

