/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ConfigurableServiceableAction;
import org.apache.cocoon.components.modules.input.InputModuleHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.BooleanUtils;

public class InputModuleAction
extends ConfigurableServiceableAction
implements ThreadSafe {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Object> map = null;
        Configuration conf = null;
        String module = parameters.getParameter("module", (String)this.settings.get("module"));
        String attrib = parameters.getParameter("attribute", (String)this.settings.get("attribute"));
        boolean single = parameters.getParameterAsBoolean("single-value", ((Boolean)this.settings.get("single-value")).booleanValue());
        if (module != null && attrib != null) {
            InputModuleHelper mhelper = new InputModuleHelper();
            mhelper.setup(this.manager);
            Object[] result = null;
            if (!single) {
                result = mhelper.getAttributeValues(objectModel, conf, module, attrib, null);
            } else {
                Object tmp = mhelper.getAttribute(objectModel, conf, module, attrib, null);
                if (tmp != null) {
                    result = new Object[]{tmp};
                }
            }
            mhelper.releaseAll();
            if (result != null && result.length != 0) {
                map = new HashMap<String, Object>();
                for (int i = 0; i < result.length; ++i) {
                    map.put(Integer.toString(i), result[i]);
                }
            }
        } else if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error("Parameter is missing: module=" + module + " attribute=" + attrib);
        }
        return map;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        boolean result = false;
        String tmp = (String)this.settings.get("single-value", "false");
        result = BooleanUtils.toBoolean((String)tmp);
        this.settings.put("single-value", new Boolean(result));
    }
}

