/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.CloningInheritableThreadLocal;
import org.apache.cocoon.components.ComponentLocatorImpl;
import org.apache.cocoon.components.DefaultSitemapConfigurationHolder;
import org.apache.cocoon.components.EnvironmentDescription;
import org.apache.cocoon.components.EnvironmentStack;
import org.apache.cocoon.components.GlobalRequestLifecycleComponent;
import org.apache.cocoon.components.ParentAware;
import org.apache.cocoon.components.RequestLifecycleComponent;
import org.apache.cocoon.components.SitemapConfigurable;
import org.apache.cocoon.components.SitemapConfigurationHolder;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;

public final class CocoonComponentManager
extends ExcaliburComponentManager
implements SourceResolver {
    private static final String PROCESS_KEY = CocoonComponentManager.class.getName();
    private static InheritableThreadLocal environmentStack = new CloningInheritableThreadLocal();
    private SourceResolver sourceResolver;
    private Map sitemapConfigurationHolders = new HashMap(15);
    private ComponentManager parentManager;
    private ArrayList parentAwareComponents = new ArrayList();
    private boolean wasDisposed;

    public CocoonComponentManager() {
        super(null, Thread.currentThread().getContextClassLoader());
    }

    public CocoonComponentManager(ClassLoader loader) {
        super(null, loader);
    }

    public CocoonComponentManager(ComponentManager manager, ClassLoader loader) {
        super(manager, loader);
        this.parentManager = manager;
    }

    public CocoonComponentManager(ComponentManager manager) {
        super(manager);
        this.parentManager = manager;
    }

    public static void enterEnvironment(Environment env, ComponentManager manager, Processor processor) {
        if (null == env || null == manager || null == processor) {
            throw new RuntimeException("CocoonComponentManager.enterEnvironment: all parameters must be set: " + env + " - " + manager + " - " + processor);
        }
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (stack == null) {
            stack = new EnvironmentStack();
            environmentStack.set(stack);
        }
        stack.push(new Object[]{env, processor, manager, new Integer(stack.getOffset())});
        stack.setOffset(stack.size() - 1);
        env.setAttribute("CocoonComponentManager.processor", processor);
    }

    public static void leaveEnvironment() {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        Object[] objs = (Object[])stack.pop();
        stack.setOffset((Integer)objs[3]);
        if (stack.isEmpty()) {
            Environment env = (Environment)objs[0];
            Map globalComponents = (Map)env.getAttribute(GlobalRequestLifecycleComponent.class.getName());
            if (globalComponents != null) {
                Iterator iter = globalComponents.values().iterator();
                while (iter.hasNext()) {
                    Object[] o = (Object[])iter.next();
                    Component c = (Component)o[0];
                    ((CocoonComponentManager)((Object)o[1])).releaseRLComponent(c);
                }
            }
            env.removeAttribute(GlobalRequestLifecycleComponent.class.getName());
        }
    }

    public static void checkEnvironment(Logger logger) throws Exception {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (stack != null && !stack.isEmpty()) {
            logger.error("ENVIRONMENT STACK HAS NOT BEEN CLEANED PROPERLY");
            throw new ProcessingException("Environment stack has not been cleaned up properly. Please report this (if possible together with a test case) to the Cocoon developers.");
        }
    }

    public static XMLConsumer createEnvironmentAwareConsumer(XMLConsumer consumer) {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        Object[] objs = (Object[])stack.getCurrent();
        return stack.getEnvironmentAwareConsumerWrapper(consumer, (Integer)objs[3]);
    }

    public static Object startProcessing(Environment env) {
        if (null == env) {
            throw new RuntimeException("CocoonComponentManager.startProcessing: environment must be set.");
        }
        EnvironmentDescription desc = new EnvironmentDescription(env);
        env.getObjectModel().put(PROCESS_KEY, desc);
        env.startingProcessing();
        return desc;
    }

    public static void endProcessing(Environment env, Object key) {
        env.finishingProcessing();
        EnvironmentDescription desc = (EnvironmentDescription)key;
        desc.release();
        env.getObjectModel().remove(PROCESS_KEY);
    }

    public static Environment getCurrentEnvironment() {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null != stack && !stack.empty()) {
            return (Environment)((Object[])stack.getCurrent())[0];
        }
        return null;
    }

    public static Processor getCurrentProcessor() {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null != stack && !stack.empty()) {
            return (Processor)((Object[])stack.getCurrent())[1];
        }
        return null;
    }

    public static Processor getLastProcessor(Environment env) {
        return (Processor)env.getAttribute("CocoonComponentManager.processor");
    }

    public static ComponentManager getSitemapComponentManager() {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null != stack && !stack.empty()) {
            Object[] o = (Object[])stack.peek();
            return (ComponentManager)o[2];
        }
        return null;
    }

    public Component lookup(String role) throws ComponentException {
        EnvironmentDescription desc;
        Map objectModel;
        Object[] objects;
        Component component;
        Object[] objects2;
        Map objectModel2;
        EnvironmentDescription desc2;
        if (null == role) {
            String message = "ComponentLocator Attempted to retrieve component with null role.";
            throw new ComponentException(role, "ComponentLocator Attempted to retrieve component with null role.");
        }
        if (role.equals(SourceResolver.ROLE)) {
            if (null == this.sourceResolver) {
                if (this.wasDisposed) {
                    this.getLogger().warn("Trying to lookup SourceResolver on disposed CocoonComponentManager");
                }
                this.sourceResolver = (SourceResolver)super.lookup(role);
            }
            return this;
        }
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null != stack && !stack.empty() && null != (desc2 = (EnvironmentDescription)(objectModel2 = ((Environment)(objects2 = (Object[])stack.getCurrent())[0]).getObjectModel()).get(PROCESS_KEY))) {
            Component component2 = desc2.getRequestLifecycleComponent(role);
            if (null != component2) {
                return component2;
            }
            component2 = desc2.getGlobalRequestLifecycleComponent(role);
            if (null != component2) {
                return component2;
            }
        }
        if (null != (component = super.lookup(role)) && component instanceof RequestLifecycleComponent) {
            if (stack == null || stack.empty()) {
                throw new ComponentException(role, "ComponentManager has no Environment Stack.");
            }
            objects = (Object[])stack.getCurrent();
            objectModel = ((Environment)objects[0]).getObjectModel();
            desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
            if (null != desc && !desc.containsRequestLifecycleComponent(role)) {
                try {
                    if (component instanceof Recomposable) {
                        ((Recomposable)component).recompose((ComponentManager)this);
                    }
                    ((RequestLifecycleComponent)component).setup((org.apache.cocoon.environment.SourceResolver)objects[0], objectModel);
                }
                catch (Exception local) {
                    throw new ComponentException(role, "Exception during setup of RequestLifecycleComponent.", (Throwable)local);
                }
                desc.addRequestLifecycleComponent(role, component, (ComponentManager)this);
            }
        }
        if (null != component && component instanceof GlobalRequestLifecycleComponent) {
            if (stack == null || stack.empty()) {
                throw new ComponentException(role, "ComponentManager has no Environment Stack.");
            }
            objects = (Object[])stack.getCurrent();
            objectModel = ((Environment)objects[0]).getObjectModel();
            desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
            if (null != desc && !desc.containsGlobalRequestLifecycleComponent(role)) {
                try {
                    if (component instanceof Recomposable) {
                        ((Recomposable)component).recompose((ComponentManager)this);
                    }
                    ((GlobalRequestLifecycleComponent)component).setup((org.apache.cocoon.environment.SourceResolver)objects[0], objectModel);
                }
                catch (Exception local) {
                    throw new ComponentException(role, "Exception during setup of RequestLifecycleComponent.", (Throwable)local);
                }
                desc.addGlobalRequestLifecycleComponent(role, component, (ComponentManager)this);
            }
        }
        if (null != component && component instanceof SitemapConfigurable) {
            SitemapConfigurationHolder holder = (SitemapConfigurationHolder)this.sitemapConfigurationHolders.get(role);
            if (null == holder) {
                holder = new DefaultSitemapConfigurationHolder(role);
                this.sitemapConfigurationHolders.put(role, holder);
            }
            try {
                ((SitemapConfigurable)component).configure(holder);
            }
            catch (ConfigurationException ce) {
                throw new ComponentException(role, "Exception during setup of SitemapConfigurable.", (Throwable)ce);
            }
        }
        return component;
    }

    public void release(Component component) {
        if (null == component) {
            return;
        }
        if (component instanceof RequestLifecycleComponent || component instanceof GlobalRequestLifecycleComponent) {
            return;
        }
        if (component == this) {
            return;
        }
        super.release(component);
    }

    protected void releaseRLComponent(Component component) {
        super.release(component);
    }

    public static void addComponentForAutomaticRelease(ComponentSelector selector, Component component, ComponentManager manager) throws ProcessingException {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null != stack && !stack.empty()) {
            Object[] objects = (Object[])stack.get(0);
            Map objectModel = ((Environment)objects[0]).getObjectModel();
            EnvironmentDescription desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
            if (null != desc) {
                desc.addToAutoRelease(selector, component, manager);
            }
        } else {
            throw new ProcessingException("Unable to add component for automatic release: no environment available.");
        }
    }

    public static void addComponentForAutomaticRelease(ComponentManager manager, Component component) throws ProcessingException {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null != stack && !stack.empty()) {
            Object[] objects = (Object[])stack.get(0);
            Map objectModel = ((Environment)objects[0]).getObjectModel();
            EnvironmentDescription desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
            if (null != desc) {
                desc.addToAutoRelease(manager, component);
            }
        } else {
            throw new ProcessingException("Unable to add component for automatic release: no environment available.");
        }
    }

    public static void removeFromAutomaticRelease(Component component) throws ProcessingException {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null != stack && !stack.empty()) {
            Object[] objects = (Object[])stack.get(0);
            Map objectModel = ((Environment)objects[0]).getObjectModel();
            EnvironmentDescription desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
            if (null != desc) {
                desc.removeFromAutoRelease(component);
            }
        } else {
            throw new ProcessingException("Unable to remove component from automatic release: no environment available.");
        }
    }

    public void dispose() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("CocoonComponentManager.dispose() called");
        }
        if (null != this.sourceResolver) {
            super.release((Component)this.sourceResolver);
        }
        super.dispose();
        this.sourceResolver = null;
        this.wasDisposed = true;
    }

    public Source resolveURI(String location) throws MalformedURLException, IOException, SourceException {
        return this.resolveURI(location, null, null);
    }

    public Source resolveURI(String location, String baseURI, Map parameters) throws MalformedURLException, IOException, SourceException {
        EnvironmentStack stack;
        if (baseURI == null && null != (stack = (EnvironmentStack)environmentStack.get()) && !stack.empty()) {
            Object[] objects = (Object[])stack.getCurrent();
            baseURI = ((Environment)objects[0]).getContext();
        }
        return this.sourceResolver.resolveURI(location, baseURI, parameters);
    }

    public void release(Source source) {
        this.sourceResolver.release(source);
    }

    public void addComponent(String role, Class clazz, Configuration conf) throws ComponentException {
        super.addComponent(role, clazz, conf);
        if (ParentAware.class.isAssignableFrom(clazz)) {
            this.parentAwareComponents.add(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        super.initialize();
        if (this.parentAwareComponents == null) {
            throw new ComponentException(null, "CocoonComponentManager already initialized");
        }
        Iterator iter = this.parentAwareComponents.iterator();
        while (iter.hasNext()) {
            String role = (String)iter.next();
            this.getLogger().debug(".. " + role);
            if (this.parentManager == null || !this.parentManager.hasComponent(role)) continue;
            Component component = null;
            try {
                component = this.lookup(role);
                ((ParentAware)component).setParentLocator(new ComponentLocatorImpl(this.parentManager, role));
            }
            catch (ComponentException ignore) {}
            continue;
            finally {
                this.release(component);
            }
        }
        this.parentAwareComponents = null;
    }
}

