/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.ChainedConfiguration;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.ExtendedComponentSelector;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.source.impl.DelayedRefreshSourceWrapper;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ForwardRedirector;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;
import org.apache.cocoon.environment.wrapper.MutableEnvironmentFacade;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.ContentHandler;

public class TreeProcessor
extends AbstractLogEnabled
implements ThreadSafe,
Processor,
Composable,
Configurable,
RoleManageable,
Contextualizable,
Disposable {
    public static final String REDIRECTOR_ATTR = "sitemap:redirector";
    public static final String COCOON_REDIRECT_ATTR = "sitemap:cocoon-redirect";
    private static final String XCONF_URL = "resource://org/apache/cocoon/components/treeprocessor/treeprocessor-builtins.xml";
    protected TreeProcessor parent;
    protected Context context;
    protected ComponentManager manager;
    protected RoleManager roleManager;
    protected String language;
    protected ExtendedComponentSelector builderSelector;
    protected ProcessingNode rootNode;
    protected List disposableNodes;
    protected long lastModified = 0L;
    protected DelayedRefreshSourceWrapper source;
    protected long lastModifiedDelay;
    protected Configuration currentLanguage;
    protected String fileName;
    protected boolean checkReload;
    protected Configuration componentConfigurations;
    protected Map sitemapComponentConfigurations;
    protected ComponentManager sitemapComponentManager;
    protected SourceResolver resolver;

    public TreeProcessor() {
        this.language = "sitemap";
        this.checkReload = true;
        this.lastModifiedDelay = 1000L;
    }

    protected TreeProcessor(TreeProcessor parent, ComponentManager manager, String language) {
        this.parent = parent;
        this.language = language == null ? parent.language : language;
        this.enableLogging(parent.getLogger());
        this.context = parent.context;
        this.roleManager = parent.roleManager;
        this.builderSelector = parent.builderSelector;
        this.checkReload = parent.checkReload;
        this.lastModifiedDelay = parent.lastModifiedDelay;
        this.manager = manager;
    }

    public TreeProcessor createChildProcessor(ComponentManager manager, String language, Source source) throws Exception {
        TreeProcessor child = new TreeProcessor(this, manager, language);
        child.source = new DelayedRefreshSourceWrapper(source, this.lastModifiedDelay);
        return child;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void setRoleManager(RoleManager rm) {
        this.roleManager = rm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration config) throws ConfigurationException {
        Configuration builtin;
        this.fileName = config.getAttribute("file", null);
        this.checkReload = config.getAttributeAsBoolean("check-reload", true);
        Configuration rootLangConfig = config.getChild("root-language", false);
        if (rootLangConfig != null) {
            this.language = rootLangConfig.getAttribute("name");
        }
        String xconfURL = config.getAttribute("config", XCONF_URL);
        this.lastModifiedDelay = config.getChild("reload").getAttributeAsLong("delay", 1000L);
        try {
            Source source = this.resolver.resolveURI(xconfURL);
            try {
                SAXConfigurationHandler handler = new SAXConfigurationHandler();
                SourceUtil.toSAX(this.manager, source, null, (ContentHandler)handler);
                builtin = handler.getConfiguration();
            }
            finally {
                this.resolver.release(source);
            }
        }
        catch (Exception e) {
            String msg = "Error while reading " + xconfURL + ": " + e.getMessage();
            throw new ConfigurationException(msg, (Throwable)e);
        }
        finally {
            this.manager.release((Component)this.resolver);
        }
        this.builderSelector = new ExtendedComponentSelector(Thread.currentThread().getContextClassLoader());
        try {
            LifecycleHelper.setupComponent((Object)this.builderSelector, this.getLogger(), this.context, this.manager, this.roleManager, builtin);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not setup builder selector", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Environment environment) throws Exception {
        InvokeContext context = new InvokeContext();
        context.enableLogging(this.getLogger());
        try {
            boolean bl = this.process(environment, context);
            return bl;
        }
        finally {
            context.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingPipeline buildPipeline(Environment environment) throws Exception {
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        try {
            if (this.process(environment, context)) {
                ProcessingPipeline processingPipeline = context.getProcessingPipeline();
                return processingPipeline;
            }
            ProcessingPipeline processingPipeline = null;
            return processingPipeline;
        }
        finally {
            context.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(Environment environment, InvokeContext context) throws Exception {
        boolean bl;
        if (this.rootNode == null || this.checkReload && this.source.getLastModified() > this.lastModified) {
            this.setupRootNode(environment);
        }
        CocoonComponentManager.enterEnvironment(environment, this.sitemapComponentManager, this);
        Map objectModel = environment.getObjectModel();
        Object oldResolver = objectModel.get("source-resolver");
        Object oldRedirector = environment.getAttribute(REDIRECTOR_ATTR);
        TreeProcessorRedirector redirector = new TreeProcessorRedirector(environment, context);
        this.setupLogger(redirector);
        objectModel.put("source-resolver", environment);
        environment.setAttribute(REDIRECTOR_ATTR, redirector);
        try {
            boolean success;
            bl = success = this.rootNode.invoke(environment, context);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            CocoonComponentManager.leaveEnvironment();
            environment.setAttribute(REDIRECTOR_ATTR, oldRedirector);
            objectModel.put("source-resolver", oldResolver);
            throw throwable;
        }
        CocoonComponentManager.leaveEnvironment();
        environment.setAttribute(REDIRECTOR_ATTR, oldRedirector);
        objectModel.put("source-resolver", oldResolver);
        return bl;
    }

    private boolean handleCocoonRedirect(String uri, Environment environment, InvokeContext context) throws Exception {
        MutableEnvironmentFacade facade;
        MutableEnvironmentFacade mutableEnvironmentFacade = facade = environment instanceof MutableEnvironmentFacade ? (MutableEnvironmentFacade)environment : null;
        if (facade != null) {
            environment = facade.getDelegate();
        }
        boolean isRedirect = environment.getObjectModel().remove("cocoon:forward") == null;
        Environment newEnv = new ForwardEnvironmentWrapper(environment, this.manager, uri, this.getLogger());
        if (isRedirect) {
            newEnv.setInternalRedirect(true);
        }
        if (facade != null) {
            facade.setDelegate((EnvironmentWrapper)newEnv);
            newEnv = facade;
        }
        TreeProcessor processor = newEnv.getRootContext() == newEnv.getContext() ? (TreeProcessor)this.getRootProcessor() : this;
        return processor.process(newEnv, context);
    }

    public Processor getRootProcessor() {
        TreeProcessor result = this;
        while (result.parent != null) {
            result = result.parent;
        }
        return result;
    }

    public void setComponentConfigurations(Configuration componentConfigurations) {
        this.componentConfigurations = componentConfigurations;
        this.sitemapComponentConfigurations = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getComponentConfigurations() {
        if (null == this.sitemapComponentConfigurations) {
            TreeProcessor treeProcessor = this;
            synchronized (treeProcessor) {
                if (this.sitemapComponentConfigurations == null) {
                    Configuration[] childs;
                    Configuration[] configurationArray = childs = this.componentConfigurations == null ? null : this.componentConfigurations.getChildren();
                    if (null != childs) {
                        this.sitemapComponentConfigurations = null == this.parent ? new HashMap(12) : new HashMap(this.parent.getComponentConfigurations());
                        for (int m = 0; m < childs.length; ++m) {
                            String r = this.roleManager.getRoleForName(childs[m].getName());
                            this.sitemapComponentConfigurations.put(r, new ChainedConfiguration(childs[m], (ChainedConfiguration)this.sitemapComponentConfigurations.get(r)));
                        }
                    } else {
                        this.sitemapComponentConfigurations = null == this.parent ? Collections.EMPTY_MAP : this.parent.getComponentConfigurations();
                    }
                }
            }
        }
        return this.sitemapComponentConfigurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setupRootNode(Environment env) throws Exception {
        ProcessingNode root;
        if (this.rootNode != null && this.source.getLastModified() <= this.lastModified) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.disposeTree();
        TreeBuilder builder = (TreeBuilder)this.builderSelector.select(this.language);
        try {
            if (builder instanceof Recomposable) {
                ((Recomposable)builder).recompose(this.manager);
            }
            builder.setProcessor(this);
            if (this.fileName == null) {
                this.fileName = builder.getFileName();
            }
            if (this.source == null) {
                this.source = new DelayedRefreshSourceWrapper(this.resolver.resolveURI(this.fileName), this.lastModifiedDelay);
            }
            root = builder.build(this.source);
            this.sitemapComponentManager = builder.getSitemapComponentManager();
            this.disposableNodes = builder.getDisposableNodes();
        }
        finally {
            this.builderSelector.release(builder);
        }
        this.lastModified = System.currentTimeMillis();
        if (this.getLogger().isDebugEnabled()) {
            double time = (double)(this.lastModified - startTime) / 1000.0;
            this.getLogger().debug("TreeProcessor built in " + time + " secs from " + this.source.getURI());
        }
        this.rootNode = root;
    }

    public void dispose() {
        this.disposeTree();
        if (this.parent == null) {
            this.builderSelector.dispose();
        }
        if (this.manager != null) {
            if (this.source != null) {
                this.resolver.release(this.source.getSource());
                this.source = null;
            }
            this.manager.release((Component)this.resolver);
            this.resolver = null;
            this.manager = null;
        }
    }

    protected void disposeTree() {
        if (this.disposableNodes != null) {
            for (int i = this.disposableNodes.size() - 1; i > -1; --i) {
                ((Disposable)this.disposableNodes.get(i)).dispose();
            }
            this.disposableNodes = null;
        }
    }

    private static final class ForwardEnvironmentWrapper
    extends EnvironmentWrapper {
        public ForwardEnvironmentWrapper(Environment env, ComponentManager manager, String uri, Logger logger) throws MalformedURLException {
            super(env, manager, uri, logger);
        }

        public void setStatus(int statusCode) {
            this.environment.setStatus(statusCode);
        }

        public void setContentLength(int length) {
            this.environment.setContentLength(length);
        }

        public void setContentType(String contentType) {
            this.environment.setContentType(contentType);
        }

        public String getContentType() {
            return this.environment.getContentType();
        }

        public boolean isResponseModified(long lastModified) {
            return this.environment.isResponseModified(lastModified);
        }

        public void setResponseIsNotModified() {
            this.environment.setResponseIsNotModified();
        }
    }

    private class TreeProcessorRedirector
    extends ForwardRedirector {
        private InvokeContext context;

        public TreeProcessorRedirector(Environment env, InvokeContext context) {
            super(env);
            this.context = context;
        }

        protected void cocoonRedirect(String uri) throws IOException, ProcessingException {
            try {
                TreeProcessor.this.handleCocoonRedirect(uri, this.env, this.context);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (ProcessingException pe) {
                throw pe;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                throw new ProcessingException(ex);
            }
        }
    }
}

