/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.components.notification.Notifying;
import org.apache.cocoon.components.notification.NotifyingBuilder;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.environment.Environment;

public class ErrorHandlerHelper
extends AbstractLogEnabled
implements Composable {
    private ComponentManager manager;

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeErrorHandler(ProcessingNode node, Exception ex, Environment env) throws Exception {
        Map objectModel = env.getObjectModel();
        InvokeContext errorContext = null;
        boolean nodeSuccessful = false;
        try {
            if (objectModel.get("notifying-object") == null) {
                env.tryResetResponse();
                NotifyingBuilder notifyingBuilder = (NotifyingBuilder)this.manager.lookup(NotifyingBuilder.ROLE);
                Notifying currentNotifying = null;
                try {
                    currentNotifying = notifyingBuilder.build((Object)this, ex);
                }
                finally {
                    this.manager.release((Component)notifyingBuilder);
                }
                objectModel.put("notifying-object", currentNotifying);
                objectModel.put("throwable", ex);
            }
            errorContext = new InvokeContext();
            errorContext.enableLogging(this.getLogger());
            errorContext.compose(this.manager);
            nodeSuccessful = node.invoke(env, errorContext);
        }
        catch (Exception subEx) {
            this.getLogger().error("An exception occured while handling errors at " + node.getLocation(), (Throwable)subEx);
            throw subEx;
        }
        finally {
            if (errorContext != null) {
                errorContext.dispose();
            }
        }
        if (nodeSuccessful) {
            return true;
        }
        throw ex;
    }
}

