/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.helpers;

import java.io.IOException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.components.sax.XMLTeePipe;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.transformation.helpers.IncludeCacheManager;
import org.apache.cocoon.transformation.helpers.IncludeCacheManagerSession;
import org.apache.cocoon.transformation.helpers.IncludeCacheStorageProxy;
import org.apache.cocoon.transformation.helpers.LoaderThread;
import org.apache.cocoon.transformation.helpers.ModifiableSourceIncludeCacheStorageProxy;
import org.apache.cocoon.transformation.helpers.PreemptiveBooter;
import org.apache.cocoon.transformation.helpers.PreemptiveLoader;
import org.apache.cocoon.transformation.helpers.StoreIncludeCacheStorageProxy;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.store.Store;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class DefaultIncludeCacheManager
extends AbstractLogEnabled
implements IncludeCacheManager,
ThreadSafe,
Serviceable,
Disposable,
Parameterizable,
Component {
    private ServiceManager manager;
    private SourceResolver resolver;
    private Store store;
    private IncludeCacheStorageProxy defaultCacheStorage;
    private String preemptiveLoaderURI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public IncludeCacheManagerSession getSession(Parameters pars) {
        void var3_3;
        IncludeCacheManagerSession session;
        String sourceURI = pars.getParameter("source", null);
        if (null == sourceURI) {
            session = new IncludeCacheManagerSession(pars, this.defaultCacheStorage);
        } else {
            Source source = null;
            try {
                source = this.resolver.resolveURI(sourceURI);
                ModifiableSourceIncludeCacheStorageProxy proxy = new ModifiableSourceIncludeCacheStorageProxy(this.resolver, source.getURI(), this.getLogger());
                session = new IncludeCacheManagerSession(pars, proxy);
            }
            catch (Exception local) {
                session = new IncludeCacheManagerSession(pars, this.defaultCacheStorage);
                this.getLogger().warn("Error creating writeable source.", (Throwable)local);
            }
            finally {
                this.resolver.release(source);
            }
        }
        if (var3_3.isPreemptive()) {
            if (null == this.preemptiveLoaderURI) {
                this.getLogger().error("Preemptive loading is turned off because the preemptive-loader-url is not configured.");
                var3_3.setPreemptive(false);
            } else if (!PreemptiveLoader.getInstance().alive) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Booting preemptive loader: " + this.preemptiveLoaderURI);
                }
                PreemptiveBooter thread = new PreemptiveBooter();
                thread.setURI(this.preemptiveLoaderURI);
                thread.start();
                Thread.yield();
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating cache manager session: " + var3_3);
        }
        return var3_3;
    }

    public String load(String uri, IncludeCacheManagerSession session) throws IOException, SourceException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Load " + uri + " for session " + session);
        }
        if (uri.indexOf("://") == -1) {
            Source source = session.resolveURI(uri, this.resolver);
            uri = source.getURI();
        }
        if (session.isParallel() && !session.isPreemptive()) {
            IncludeCacheStorageProxy storage = session.getCacheStorageProxy();
            CachedResponse response = (CachedResponse)storage.get(uri);
            if (null != response) {
                SourceValidity[] validities = response.getValidityObjects();
                if (!session.isPurging() && validities[0].isValid() == 1) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Using cached response for parallel processing.");
                    }
                    session.add(uri, response.getResponse());
                    return uri;
                }
                storage.remove(uri);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Starting parallel thread for loading " + uri);
            }
            try {
                XMLSerializer serializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
                Source source = session.resolveURI(uri, this.resolver);
                LoaderThread loader = new LoaderThread(source, serializer, this.manager);
                Thread thread = new Thread(loader);
                session.add(uri, loader);
                thread.start();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Thread started for " + uri);
                }
            }
            catch (ServiceException ce) {
                throw new SourceException("Unable to lookup thread pool or xml serializer.", (Throwable)ce);
            }
            catch (Exception e) {
                throw new SourceException("Unable to get pooled thread.", (Throwable)e);
            }
        }
        return uri;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stream(String uri, IncludeCacheManagerSession session, XMLConsumer handler) throws IOException, SourceException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Stream " + uri + " for session " + session);
        }
        if (session.isParallel() && !session.isPreemptive()) {
            byte[] result;
            Object object = session.get(uri);
            if (null == object) {
                throw new SAXException("No pooled thread found for " + uri);
            }
            if (object instanceof LoaderThread) {
                LoaderThread loader = (LoaderThread)object;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Waiting for pooled thread to finish loading.");
                }
                while (!loader.finished) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Pooled thread finished loading.");
                }
                if (null != loader.exception) {
                    if (loader.exception instanceof SAXException) {
                        throw (SAXException)loader.exception;
                    }
                    if (loader.exception instanceof SourceException) {
                        throw (SourceException)((Object)loader.exception);
                    }
                    if (!(loader.exception instanceof IOException)) throw new SAXException("Exception.", loader.exception);
                    throw (IOException)loader.exception;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Streaming from pooled thread.");
                }
                result = loader.content;
                if (session.getExpires() > 0L) {
                    SourceValidity[] validities = new SourceValidity[]{session.getExpiresValidity()};
                    CachedResponse response = new CachedResponse(validities, result);
                    session.getCacheStorageProxy().put(uri, response);
                }
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Streaming from cached response.");
                }
                result = (byte[])object;
            }
            XMLDeserializer deserializer = null;
            try {
                deserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                deserializer.setConsumer(handler);
                deserializer.deserialize(result);
                return;
            }
            catch (ServiceException ce) {
                throw new SAXException("Unable to lookup xml deserializer.", (Exception)((Object)ce));
            }
            finally {
                this.manager.release((Object)deserializer);
            }
        }
        IncludeCacheStorageProxy storage = session.getCacheStorageProxy();
        CachedResponse response = (CachedResponse)storage.get(uri);
        if (null != response) {
            SourceValidity[] validities = response.getValidityObjects();
            if (!session.isPurging() && (session.isPreemptive() || validities[0].isValid() == 1)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Streaming from cached response.");
                }
                XMLDeserializer deserializer = null;
                try {
                    deserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                    deserializer.setConsumer(handler);
                    deserializer.deserialize(response.getResponse());
                }
                catch (ServiceException ce) {
                    throw new SAXException("Unable to lookup xml deserializer.", (Exception)((Object)ce));
                }
                finally {
                    this.manager.release((Object)deserializer);
                }
                if (session.getExpires() <= 0L) return;
                if (!session.isPreemptive()) return;
                if (validities[0].isValid() == 1) return;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Add uri to preemptive loader list " + uri);
                }
                if (!PreemptiveLoader.getInstance().alive) {
                    this.getLogger().error("Preemptive loader has not started yet.");
                }
                PreemptiveLoader.getInstance().add(session.getCacheStorageProxy(), uri, session.getExpires());
                return;
            }
            storage.remove(uri);
        }
        XMLSerializer serializer = null;
        try {
            Source source = session.resolveURI(uri, this.resolver);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Streaming directly from source.");
            }
            if (session.getExpires() > 0L) {
                serializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
                XMLTeePipe tee = new XMLTeePipe(handler, serializer);
                SourceUtil.toSAX(source, (ContentHandler)((Object)tee));
                SourceValidity[] validities = new SourceValidity[]{session.getExpiresValidity()};
                CachedResponse response2 = new CachedResponse(validities, (byte[])serializer.getSAXFragment());
                session.getCacheStorageProxy().put(uri, response2);
            } else {
                SourceUtil.toSAX(source, (ContentHandler)((Object)handler));
            }
        }
        catch (ProcessingException pe) {
            try {
                throw new SAXException("ProcessingException", (Exception)((Object)pe));
                catch (ServiceException e) {
                    throw new SAXException("Unable to lookup xml serializer.", (Exception)((Object)e));
                }
            }
            catch (Throwable throwable) {
                this.manager.release(serializer);
                throw throwable;
            }
        }
        this.manager.release((Object)serializer);
    }

    public void terminateSession(IncludeCacheManagerSession session) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Terminating cache manager session " + session);
        }
        session.cleanup(this.resolver);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void dispose() {
        PreemptiveLoader.getInstance().stop();
        if (null != this.manager) {
            this.manager.release((Object)this.resolver);
            this.manager.release((Object)this.store);
            this.store = null;
            this.resolver = null;
            this.manager = null;
            this.defaultCacheStorage = null;
        }
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.preemptiveLoaderURI = parameters.getParameter("preemptive-loader-url", null);
        if (null != this.preemptiveLoaderURI && this.preemptiveLoaderURI.indexOf("://") == -1) {
            throw new ParameterException("The preemptive-loader-url must be absolute: " + this.preemptiveLoaderURI);
        }
        String storeRole = parameters.getParameter("use-store", Store.ROLE);
        try {
            this.store = (Store)this.manager.lookup(storeRole);
        }
        catch (ServiceException e) {
            throw new ParameterException("Unable to lookup store with role " + storeRole, (Throwable)e);
        }
        this.defaultCacheStorage = new StoreIncludeCacheStorageProxy(this.store, this.getLogger());
    }
}

