/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jasig.portal.PortalException;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.services.LogService;

public class RDBMServices {
    private static boolean bPropsLoaded = false;
    private static String sJdbcDriver = null;
    private static String sJdbcUrl = null;
    private static String sJdbcUser = null;
    private static final Properties jdbcDriverProps = new Properties();
    private static Driver jdbcDriver;
    public static int RETRY_COUNT;
    private static String prevErrorMsg;
    protected static final boolean getDatasourceFromJndi;
    protected static final boolean usePreparedStatements;
    protected static boolean supportsPreparedStatements;
    public static boolean supportsOuterJoins;
    public static boolean supportsTransactions;
    private static String tsStart;
    private static String tsEnd;
    private static final JdbcDb jdbcDb;
    private static final PostgreSQLDb postgreSQLDb;
    private static final OracleDb oracleDb;
    private static final JoinQueryString[] joinTests;
    public static IJoinQueryString joinQuery;
    public static final String PORTAL_DB = "PortalDb";
    public static final String PERSON_DB = "PersonDb";
    private static boolean useToDate;
    static /* synthetic */ Class class$org$jasig$portal$RDBMServices;

    protected static void loadProps() throws Exception {
        try {
            if (!bPropsLoaded) {
                InputStream inStream = (class$org$jasig$portal$RDBMServices == null ? (class$org$jasig$portal$RDBMServices = RDBMServices.class$("org.jasig.portal.RDBMServices")) : class$org$jasig$portal$RDBMServices).getResourceAsStream("/properties/rdbm.properties");
                Properties jdbcProps = new Properties();
                jdbcProps.load(inStream);
                sJdbcDriver = jdbcProps.getProperty("jdbcDriver");
                sJdbcUrl = jdbcProps.getProperty("jdbcUrl");
                sJdbcUser = jdbcProps.getProperty("jdbcUser");
                jdbcDriverProps.put("user", sJdbcUser);
                jdbcDriverProps.put("password", jdbcProps.getProperty("jdbcPassword"));
                jdbcDriver = (Driver)Class.forName(sJdbcDriver).newInstance();
                bPropsLoaded = true;
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public static Connection getConnection(String dbName) {
        Connection conn = null;
        try {
            InitialContext initCtx = new InitialContext();
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            DataSource ds = (DataSource)envCtx.lookup("jdbc/" + dbName);
            if (ds != null) {
                conn = ds.getConnection();
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                    conn.setAutoCommit(true);
                }
            } else {
                LogService.log(LogService.ERROR, "The database '" + dbName + "' could not be found.");
            }
        }
        catch (NamingException ne) {
            LogService.log(LogService.ERROR, ne);
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
        }
        return conn;
    }

    public static Connection getConnection() {
        Connection conn = null;
        if (getDatasourceFromJndi && (conn = RDBMServices.getConnection(PORTAL_DB)) != null) {
            return conn;
        }
        if (bPropsLoaded) {
            for (int i = 0; i < RETRY_COUNT && conn == null; ++i) {
                try {
                    conn = jdbcDriver.connect(sJdbcUrl, jdbcDriverProps);
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                        conn.setAutoCommit(true);
                    }
                    prevErrorMsg = "";
                    continue;
                }
                catch (SQLException SQLe) {
                    String errMsg = SQLe.getMessage();
                    if (errMsg.equals(prevErrorMsg)) continue;
                    LogService.log(LogService.WARN, "Driver " + sJdbcDriver + " produced error: " + SQLe.getMessage() + ". Trying to get connection again.");
                    LogService.log(LogService.INFO, SQLe);
                    prevErrorMsg = errMsg;
                }
            }
        }
        return conn;
    }

    public static void releaseConnection(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
    }

    public static String getJdbcDriver() {
        return sJdbcDriver;
    }

    public static String getJdbcUrl() {
        return sJdbcUrl;
    }

    public static String getJdbcUser() {
        return sJdbcUser;
    }

    public static final void commit(Connection connection) throws SQLException {
        if (supportsTransactions) {
            connection.commit();
        }
    }

    public static final void setAutoCommit(Connection connection, boolean autocommit) throws SQLException {
        if (supportsTransactions) {
            connection.setAutoCommit(autocommit);
        }
    }

    public static final void rollback(Connection connection) throws SQLException {
        if (!supportsTransactions) {
            LogService.log(LogService.SEVERE, "RDBMUserLayout::rollback() called, but JDBC/DB does not support transactions. User data most likely corrupted");
            throw new SQLException("Unable to rollback user data");
        }
        connection.rollback();
    }

    public static final String dbFlag(boolean flag) {
        return flag ? "Y" : "N";
    }

    public static final boolean dbFlag(String flag) {
        return flag != null && (flag.equalsIgnoreCase("Y") || flag.equalsIgnoreCase("T"));
    }

    public static final String sqlTimeStamp() {
        return RDBMServices.sqlTimeStamp(System.currentTimeMillis());
    }

    public static final String sqlTimeStamp(long date) {
        if (useToDate) {
            SimpleDateFormat toDateTime = new SimpleDateFormat("yyyy MM dd HH:mm:ss");
            return "TO_DATE('" + toDateTime.format(new java.util.Date(date)) + "', 'YYYY MM DD HH24:MI:SS')";
        }
        return tsStart + "'" + new Timestamp(date).toString() + "'" + tsEnd;
    }

    public static final String sqlTimeStamp(java.util.Date date) {
        if (date == null) {
            return "NULL";
        }
        return RDBMServices.sqlTimeStamp(date.getTime());
    }

    public static final String sqlEscape(String sql) {
        if (sql == null) {
            return "";
        }
        int primePos = sql.indexOf("'");
        if (primePos == -1) {
            return sql;
        }
        StringBuffer sb = new StringBuffer(sql.length() + 4);
        int startPos = 0;
        do {
            sb.append(sql.substring(startPos, primePos + 1));
            sb.append("'");
        } while ((primePos = sql.indexOf("'", startPos = primePos + 1)) != -1);
        sb.append(sql.substring(startPos));
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        RETRY_COUNT = 5;
        prevErrorMsg = "";
        getDatasourceFromJndi = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.RDBMServices.getDatasourceFromJndi");
        usePreparedStatements = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.RDBMServices.usePreparedStatements");
        supportsPreparedStatements = false;
        supportsOuterJoins = false;
        supportsTransactions = false;
        tsStart = "";
        tsEnd = "";
        jdbcDb = new JdbcDb("{oj UP_USER LEFT OUTER JOIN UP_USER_LAYOUT ON UP_USER.USER_ID = UP_USER_LAYOUT.USER_ID} WHERE");
        postgreSQLDb = new PostgreSQLDb("UP_USER LEFT OUTER JOIN UP_USER_LAYOUT ON UP_USER.USER_ID = UP_USER_LAYOUT.USER_ID WHERE");
        oracleDb = new OracleDb("UP_USER, UP_USER_LAYOUT WHERE UP_USER.USER_ID = UP_USER_LAYOUT.USER_ID(+) AND");
        joinTests = new JoinQueryString[]{jdbcDb, postgreSQLDb, oracleDb};
        joinQuery = null;
        useToDate = false;
        try {
            RDBMServices.loadProps();
            if (!bPropsLoaded && !getDatasourceFromJndi) {
                System.err.println("Unable to connect to database");
                throw new PortalException("Unable to connect to database");
            }
            Connection con = RDBMServices.getConnection();
            if (con == null) {
                System.err.println("Unable to connect to database");
                throw new SQLException("Unable to connect to database");
            }
            try {
                Statement stmt;
                Statement stmt2;
                String sql;
                block50: {
                    ResultSet rs;
                    if (usePreparedStatements) {
                        try {
                            sql = "SELECT USER_ID FROM UP_USER WHERE USER_ID=?";
                            java.sql.PreparedStatement pstmt = con.prepareStatement(sql);
                            try {
                                pstmt.clearParameters();
                                int userId = 0;
                                pstmt.setInt(1, userId);
                                rs = pstmt.executeQuery();
                                try {
                                    if (rs.next() && userId == rs.getInt(1)) {
                                        supportsPreparedStatements = true;
                                    }
                                }
                                catch (SQLException sqle) {
                                }
                                finally {
                                    rs.close();
                                }
                            }
                            finally {
                                pstmt.close();
                            }
                        }
                        catch (SQLException sqle) {
                            // empty catch block
                        }
                    }
                    try {
                        if (!con.getMetaData().supportsOuterJoins()) break block50;
                        stmt2 = con.createStatement();
                        try {
                            for (int i = 0; i < joinTests.length; ++i) {
                                sql = "SELECT COUNT(UP_USER.USER_ID) FROM " + joinTests[i].getTestJoin() + " UP_USER.USER_ID=0";
                                try {
                                    rs = stmt2.executeQuery(sql);
                                    try {
                                        rs.close();
                                    }
                                    catch (SQLException sqle) {
                                        // empty catch block
                                    }
                                    joinQuery = joinTests[i];
                                    supportsOuterJoins = true;
                                    break;
                                }
                                catch (SQLException sqle) {
                                    continue;
                                }
                            }
                        }
                        finally {
                            stmt2.close();
                        }
                    }
                    catch (SQLException sqle) {
                        // empty catch block
                    }
                }
                try {
                    sql = "SELECT USER_ID FROM UP_USER WHERE LST_CHAN_UPDT_DT={ts '2001-01-01 00:00:00.0'} AND USER_ID=0";
                    stmt2 = con.createStatement();
                    try {
                        ResultSet rs = stmt2.executeQuery(sql);
                        try {
                            rs.close();
                        }
                        catch (SQLException sqle) {
                            // empty catch block
                        }
                        tsStart = "{ts ";
                        tsEnd = "}";
                    }
                    finally {
                        stmt2.close();
                    }
                }
                catch (SQLException sqle) {
                    try {
                        SimpleDateFormat oracleTime = new SimpleDateFormat("yyyy MM dd HH:mm:ss");
                        sql = "SELECT USER_ID FROM UP_USER WHERE LST_CHAN_UPDT_DT = TO_DATE('2001 01 01 00:00', 'YYYY MM DD HH24:MI:SS') AND USER_ID=0";
                        stmt = con.createStatement();
                        try {
                            ResultSet rs = stmt.executeQuery(sql);
                            try {
                                rs.close();
                            }
                            catch (SQLException sqle2) {
                                // empty catch block
                            }
                        }
                        finally {
                            stmt.close();
                        }
                        useToDate = true;
                    }
                    catch (SQLException sqle3) {
                        // empty catch block
                    }
                }
                String tranMsg = "";
                DatabaseMetaData md = con.getMetaData();
                if (md.supportsTransactions()) {
                    try {
                        con.setAutoCommit(false);
                        stmt = con.createStatement();
                        try {
                            sql = "UPDATE UP_USER SET LST_CHAN_UPDT_DT=" + RDBMServices.sqlTimeStamp() + " WHERE USER_ID=0";
                            stmt.executeUpdate(sql);
                            con.rollback();
                            supportsTransactions = true;
                        }
                        finally {
                            stmt.close();
                        }
                    }
                    catch (SQLException sqle) {
                        tranMsg = " (driver lies)";
                    }
                }
                LogService.log(LogService.INFO, md.getDatabaseProductName() + "/" + RDBMServices.getJdbcDriver() + " (" + md.getDriverVersion() + ") database/driver supports:\n     Prepared statements=" + supportsPreparedStatements + ", Outer joins=" + supportsOuterJoins + ", Transactions=" + supportsTransactions + tranMsg + ", '{ts' metasyntax=" + tsEnd.equals("}") + ", TO_DATE()=" + useToDate);
                return;
            }
            finally {
                RDBMServices.releaseConnection(con);
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
    }

    public static final class PostgreSQLDb
    extends JoinQueryString {
        public PostgreSQLDb(String testString) {
            this.setTestJoin(testString);
        }
    }

    public static final class OracleDb
    extends JoinQueryString {
        public OracleDb(String testString) {
            this.setTestJoin(testString);
        }
    }

    public static final class JdbcDb
    extends JoinQueryString {
        public JdbcDb(String testString) {
            this.setTestJoin(testString);
        }
    }

    public static abstract class JoinQueryString
    implements IJoinQueryString {
        private HashMap queryStrings = new HashMap();
        private String testJoin;

        protected void setTestJoin(String query) {
            this.testJoin = query;
        }

        protected String getTestJoin() {
            return this.testJoin;
        }

        public String getQuery(String key) throws SQLException {
            String query = (String)this.queryStrings.get(key);
            if (query == null) {
                throw new SQLException("Missing query");
            }
            return query;
        }

        public void addQuery(String key, String value) throws SQLException {
            if (this.queryStrings.containsKey(key)) {
                throw new SQLException("Trying to add duplicate query");
            }
            this.queryStrings.put(key, value);
        }
    }

    public static interface IJoinQueryString {
        public String getQuery(String var1) throws SQLException;

        public void addQuery(String var1, String var2) throws SQLException;
    }

    public static final class PreparedStatement {
        private Connection con;
        private String query;
        private String activeQuery;
        private java.sql.PreparedStatement pstmt;
        private Statement stmt;
        private int lastIndex;

        public PreparedStatement(Connection con, String query) throws SQLException {
            this.con = con;
            this.activeQuery = this.query = query;
            if (supportsPreparedStatements) {
                this.pstmt = con.prepareStatement(query);
            } else {
                this.stmt = con.createStatement();
            }
        }

        public void clearParameters() throws SQLException {
            if (supportsPreparedStatements) {
                this.pstmt.clearParameters();
            } else {
                this.lastIndex = 0;
                this.activeQuery = this.query;
            }
        }

        public void setDate(int index, Date value) throws SQLException {
            if (supportsPreparedStatements) {
                this.pstmt.setDate(index, value);
            } else {
                if (index != this.lastIndex + 1) {
                    throw new SQLException("Out of order index");
                }
                int pos = this.activeQuery.indexOf("?");
                if (pos == -1) {
                    throw new SQLException("Missing '?'");
                }
                this.activeQuery = this.activeQuery.substring(0, pos) + RDBMServices.sqlTimeStamp(value) + this.activeQuery.substring(pos + 1);
                this.lastIndex = index;
            }
        }

        public void setInt(int index, int value) throws SQLException {
            if (supportsPreparedStatements) {
                this.pstmt.setInt(index, value);
            } else {
                if (index != this.lastIndex + 1) {
                    throw new SQLException("Out of order index");
                }
                int pos = this.activeQuery.indexOf("?");
                if (pos == -1) {
                    throw new SQLException("Missing '?'");
                }
                this.activeQuery = this.activeQuery.substring(0, pos) + value + this.activeQuery.substring(pos + 1);
                this.lastIndex = index;
            }
        }

        public void setNull(int index, int sqlType) throws SQLException {
            if (supportsPreparedStatements) {
                this.pstmt.setNull(index, sqlType);
            } else {
                if (index != this.lastIndex + 1) {
                    throw new SQLException("Out of order index");
                }
                int pos = this.activeQuery.indexOf("?");
                if (pos == -1) {
                    throw new SQLException("Missing '?'");
                }
                this.activeQuery = this.activeQuery.substring(0, pos) + "NULL" + this.activeQuery.substring(pos + 1);
                this.lastIndex = index;
            }
        }

        public void setString(int index, String value) throws SQLException {
            if (value == null || value.length() == 0) {
                this.setNull(index, 12);
            } else if (supportsPreparedStatements) {
                this.pstmt.setString(index, value);
            } else {
                if (index != this.lastIndex + 1) {
                    throw new SQLException("Out of order index");
                }
                int pos = this.activeQuery.indexOf("?");
                if (pos == -1) {
                    throw new SQLException("Missing '?'");
                }
                this.activeQuery = this.activeQuery.substring(0, pos) + "'" + RDBMServices.sqlEscape(value) + "'" + this.activeQuery.substring(pos + 1);
                this.lastIndex = index;
            }
        }

        public void setTimestamp(int index, Timestamp value) throws SQLException {
            if (supportsPreparedStatements) {
                this.pstmt.setTimestamp(index, value);
            } else {
                if (index != this.lastIndex + 1) {
                    throw new SQLException("Out of order index");
                }
                int pos = this.activeQuery.indexOf("?");
                if (pos == -1) {
                    throw new SQLException("Missing '?'");
                }
                this.activeQuery = this.activeQuery.substring(0, pos) + RDBMServices.sqlTimeStamp(value) + this.activeQuery.substring(pos + 1);
                this.lastIndex = index;
            }
        }

        public ResultSet executeQuery() throws SQLException {
            if (supportsPreparedStatements) {
                return this.pstmt.executeQuery();
            }
            return this.stmt.executeQuery(this.activeQuery);
        }

        public int executeUpdate() throws SQLException {
            if (supportsPreparedStatements) {
                return this.pstmt.executeUpdate();
            }
            return this.stmt.executeUpdate(this.activeQuery);
        }

        public String toString() {
            if (supportsPreparedStatements) {
                return this.query;
            }
            return this.activeQuery;
        }

        public void close() throws SQLException {
            if (supportsPreparedStatements) {
                this.pstmt.close();
            } else {
                this.stmt.close();
            }
        }
    }
}

