/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.groupsmanager.commands;

import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerSessionData;
import org.jasig.portal.channels.groupsmanager.GroupsManagerXML;
import org.jasig.portal.channels.groupsmanager.Utility;
import org.jasig.portal.channels.groupsmanager.commands.GroupsManagerCommand;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.services.GroupService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EditGroup
extends GroupsManagerCommand {
    public void execute(CGroupsManagerSessionData sessionData) throws Exception {
        ChannelStaticData staticData = sessionData.staticData;
        ChannelRuntimeData runtimeData = sessionData.runtimeData;
        Document model = this.getXmlDoc(sessionData);
        Utility.logMessage("DEBUG", "EditGroup::execute(): Start");
        String parentElemId = this.getCommandArg(runtimeData);
        String userID = this.getUserID(sessionData);
        String userKey = sessionData.user.getEntityIdentifier().getKey();
        String lockKey = userID + "::" + userKey;
        Utility.logMessage("DEBUG", "EditGroup::execute(): lockKey = " + lockKey);
        Element parentElem = GroupsManagerXML.getElementById(model, parentElemId);
        String parentKey = parentElem.getAttribute("key");
        ILockableEntityGroup lockedGroup = GroupService.findLockableGroup(parentKey, lockKey);
        if (lockedGroup != null) {
            GroupsManagerXML.refreshAllNodesRecursivelyIfRequired(sessionData.getUnrestrictedData(), parentElem);
            sessionData.lockedGroup = lockedGroup;
            sessionData.mode = "edit";
            staticData.setParameter("groupParentId", parentElemId);
        }
        Utility.logMessage("DEBUG", "EditGroup::execute(): Uid of parent element = " + parentElemId);
    }
}

