/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.groups.IEntityNameFinder;
import org.jasig.portal.services.LogService;

public class ReferencePersonNameFinder
implements IEntityNameFinder {
    private static IEntityNameFinder singleton;
    private static String USER_TABLE;
    private static String USER_ID_COLUMN;
    private static String USER_NAME_COLUMN;
    private static String DIRECTORY_TABLE;
    private static String DIRECTORY_FIRST_NAME_COLUMN;
    private static String DIRECTORY_LAST_NAME_COLUMN;
    private static String DIRECTORY_USER_NAME_COLUMN;
    private Map names;
    static /* synthetic */ Class class$org$jasig$portal$security$IPerson;

    private ReferencePersonNameFinder() throws SQLException {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getDirectoryNames() throws SQLException {
        Connection conn = null;
        Statement stmnt = null;
        HashMap<String, String> directoryNames = new HashMap<String, String>();
        try {
            conn = RDBMServices.getConnection();
            try {
                stmnt = conn.createStatement();
                String sql = this.getSelectDirectoryNamesSql();
                LogService.log(LogService.DEBUG, "ReferencePersonNameFinder.getDirectoryNames(): " + sql);
                ResultSet rs = stmnt.executeQuery(sql);
                while (rs.next()) {
                    String key = "" + rs.getString(DIRECTORY_USER_NAME_COLUMN);
                    String fname = rs.getString(DIRECTORY_FIRST_NAME_COLUMN);
                    String lname = rs.getString(DIRECTORY_LAST_NAME_COLUMN);
                    if (fname == null) {
                        fname = "";
                    }
                    if (lname == null) {
                        lname = "";
                    }
                    String fullname = fname + " " + lname;
                    directoryNames.put(key, fullname);
                }
            }
            finally {
                stmnt.close();
            }
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return directoryNames;
    }

    public String getName(String key) throws Exception {
        return (String)this.primGetNames().get(key);
    }

    public Map getNames(String[] keys) throws Exception {
        HashMap<String, String> selectedNames = new HashMap<String, String>();
        for (int i = 0; i < keys.length; ++i) {
            String name = (String)this.primGetNames().get(keys[i]);
            selectedNames.put(keys[i], name);
        }
        return selectedNames;
    }

    private String getSelectDirectoryNamesSql() {
        return "SELECT " + DIRECTORY_USER_NAME_COLUMN + ", " + DIRECTORY_FIRST_NAME_COLUMN + ", " + DIRECTORY_LAST_NAME_COLUMN + " FROM " + DIRECTORY_TABLE;
    }

    private String getSelectUserNamesSql() {
        return "SELECT " + USER_NAME_COLUMN + " FROM " + USER_TABLE;
    }

    public Class getType() {
        return class$org$jasig$portal$security$IPerson == null ? (class$org$jasig$portal$security$IPerson = ReferencePersonNameFinder.class$("org.jasig.portal.security.IPerson")) : class$org$jasig$portal$security$IPerson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getUserNames() throws SQLException {
        Connection conn = null;
        Statement stmnt = null;
        HashMap<String, String> userNames = new HashMap<String, String>();
        try {
            conn = RDBMServices.getConnection();
            try {
                stmnt = conn.createStatement();
                String sql = this.getSelectUserNamesSql();
                LogService.log(LogService.DEBUG, "ReferencePersonNameFinder.getUserNames(): " + sql);
                ResultSet rs = stmnt.executeQuery(sql);
                while (rs.next()) {
                    String key = rs.getString(USER_NAME_COLUMN);
                    userNames.put(key, key);
                }
            }
            finally {
                stmnt.close();
            }
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return userNames;
    }

    private void initialize() throws SQLException {
        Map userNames = this.getUserNames();
        Map directoryNames = this.getDirectoryNames();
        Iterator i = userNames.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String directoryName = (String)directoryNames.get((String)entry.getValue());
            if (directoryName == null) continue;
            entry.setValue(directoryName);
        }
        this.names = userNames;
    }

    private Map primGetNames() {
        return this.names;
    }

    public static synchronized IEntityNameFinder singleton() throws SQLException {
        if (singleton == null) {
            singleton = new ReferencePersonNameFinder();
        }
        return singleton;
    }

    public String toString() {
        return "IEntityNameFinder for " + this.getType().getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        USER_TABLE = "UP_USER";
        USER_ID_COLUMN = "USER_ID";
        USER_NAME_COLUMN = "USER_NAME";
        DIRECTORY_TABLE = "UP_PERSON_DIR";
        DIRECTORY_FIRST_NAME_COLUMN = "FIRST_NAME";
        DIRECTORY_LAST_NAME_COLUMN = "LAST_NAME";
        DIRECTORY_USER_NAME_COLUMN = "USER_NAME";
    }
}

