/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayoutChannelDescription;
import org.jasig.portal.layout.UserLayoutNodeDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UserLayoutChannelDescription
extends UserLayoutNodeDescription
implements IUserLayoutChannelDescription {
    Hashtable parameters = new Hashtable();
    Hashtable override = new Hashtable();
    String title = null;
    String description = null;
    String className = null;
    String channelPublishId = null;
    String channelTypeId = null;
    String functionalName = null;
    long timeout = -1L;
    boolean editable = false;
    boolean hasHelp = false;
    boolean hasAbout = false;
    boolean isSecure = false;

    public UserLayoutChannelDescription() {
    }

    public UserLayoutChannelDescription(IUserLayoutChannelDescription d) {
        this();
        this.title = d.getTitle();
        this.description = d.getDescription();
        this.className = d.getClassName();
        this.channelPublishId = d.getChannelPublishId();
        this.channelTypeId = d.getChannelTypeId();
        this.functionalName = d.getFunctionalName();
        this.timeout = d.getTimeout();
        this.editable = d.isEditable();
        this.hasHelp = d.hasHelp();
        this.hasAbout = d.hasAbout();
        Enumeration enumeration = d.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String pName = (String)enumeration.nextElement();
            this.setParameterValue(pName, d.getParameterValue(pName));
            this.setParameterOverride(pName, d.getParameterOverrideValue(pName));
        }
    }

    public UserLayoutChannelDescription(Element xmlNode) throws PortalException {
        this();
        if (!xmlNode.getNodeName().equals("channel")) {
            throw new PortalException("Given XML Element is not a channel!");
        }
        this.setId(xmlNode.getAttribute("ID"));
        this.setName(xmlNode.getAttribute("name"));
        this.setUnremovable(new Boolean(xmlNode.getAttribute("unremovable")));
        this.setImmutable(new Boolean(xmlNode.getAttribute("immutable")));
        this.setTitle(xmlNode.getAttribute("title"));
        this.setDescription(xmlNode.getAttribute("description"));
        this.setClassName(xmlNode.getAttribute("class"));
        this.setChannelPublishId(xmlNode.getAttribute("chanID"));
        this.setChannelTypeId(xmlNode.getAttribute("typeID"));
        this.setFunctionalName(xmlNode.getAttribute("fname"));
        this.setTimeout(Long.parseLong(xmlNode.getAttribute("timeout")));
        this.setEditable(Boolean.valueOf(xmlNode.getAttribute("editable")));
        this.setHasHelp(Boolean.valueOf(xmlNode.getAttribute("hasHelp")));
        this.setHasAbout(Boolean.valueOf(xmlNode.getAttribute("hasAbout")));
        this.setIsSecure(Boolean.valueOf(xmlNode.getAttribute("secure")));
        for (Node n = xmlNode.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            if (n.getNodeType() != 1 || !(e = (Element)n).getNodeName().equals("parameter")) continue;
            String pName = e.getAttribute("name");
            String pValue = e.getAttribute("value");
            Boolean canOverride = new Boolean(false);
            String str_override = e.getAttribute("override");
            if (str_override != null && str_override.equals("yes")) {
                canOverride = new Boolean(true);
            }
            if (pName == null || pValue == null) continue;
            this.setParameterValue(pName, pValue);
            this.setParameterOverride(pName, canOverride);
        }
    }

    public boolean hasAbout() {
        return this.hasAbout;
    }

    public void setHasAbout(boolean v) {
        this.hasAbout = v;
    }

    public boolean hasHelp() {
        return this.hasHelp;
    }

    public void setHasHelp(boolean v) {
        this.hasHelp = v;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean v) {
        this.editable = v;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long v) {
        this.timeout = v;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setIsSecure(boolean secure) {
        this.isSecure = secure;
    }

    public String getFunctionalName() {
        return this.functionalName;
    }

    public void setFunctionalName(String v) {
        this.functionalName = v;
    }

    public String getChannelSubscribeId() {
        return super.getId();
    }

    public void setChannelSubscribeId(String v) {
        super.setId(v);
    }

    public String getChannelTypeId() {
        return this.channelTypeId;
    }

    public void setChannelTypeId(String v) {
        this.channelTypeId = v;
    }

    public String getChannelPublishId() {
        return this.channelPublishId;
    }

    public void setChannelPublishId(String v) {
        this.channelPublishId = v;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String v) {
        this.className = v;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String v) {
        this.title = v;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String v) {
        this.description = v;
    }

    public String setParameterValue(String parameterName, String parameterValue) {
        return this.parameters.put(parameterName, parameterValue);
    }

    public String getParameterValue(String parameterName) {
        return (String)this.parameters.get(parameterName);
    }

    public boolean getParameterOverrideValue(String parameterName) {
        Boolean boolValue = (Boolean)this.override.get(parameterName);
        if (boolValue != null) {
            return boolValue;
        }
        return true;
    }

    public Collection getParameterValues() {
        return this.parameters.values();
    }

    public int numberOfParameters() {
        return this.parameters.size();
    }

    public void clearParameters() {
        this.parameters.clear();
        this.override.clear();
    }

    public boolean canOverrideParameter(String parameterName) {
        Boolean ov = (Boolean)this.override.get(parameterName);
        if (ov != null) {
            return ov;
        }
        return false;
    }

    public void setParameterOverride(String parameterName, boolean canOverride) {
        if (this.parameters.get(parameterName) != null) {
            this.override.put(parameterName, new Boolean(canOverride));
        }
    }

    public String remove(String parameterName) {
        return (String)this.parameters.remove(parameterName);
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public boolean containsParameter(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    public Element getXML(Document root) {
        Element node = root.createElement("channel");
        this.addNodeAttributes(node);
        this.addParameterChildren(node, root);
        return node;
    }

    protected void addParameterChildren(Element node, Document root) {
        Enumeration enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            Element pElement = root.createElement("parameter");
            String pName = (String)enumeration.nextElement();
            pElement.setAttribute("name", pName);
            pElement.setAttribute("value", this.getParameterValue(pName));
            pElement.setAttribute("override", this.getParameterOverrideValue(pName) ? "yes" : "no");
            node.appendChild(pElement);
        }
    }

    public void addNodeAttributes(Element node) {
        super.addNodeAttributes(node);
        node.setAttribute("title", this.getTitle());
        node.setAttribute("description", this.getDescription());
        node.setAttribute("class", this.getClassName());
        node.setAttribute("chanID", this.getChannelPublishId());
        node.setAttribute("typeID", this.getChannelTypeId());
        node.setAttribute("fname", this.getFunctionalName());
        node.setAttribute("timeout", Long.toString(this.getTimeout()));
        node.setAttribute("editable", new Boolean(this.isEditable()).toString());
        node.setAttribute("hasHelp", new Boolean(this.hasHelp()).toString());
        node.setAttribute("hasAbout", new Boolean(this.hasAbout()).toString());
        node.setAttribute("secure", new Boolean(this.isSecure()).toString());
    }

    public int getType() {
        return 1;
    }
}

