/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.restrictions;

import java.util.StringTokenizer;
import java.util.Vector;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.restrictions.UserLayoutRestriction;
import org.jasig.portal.utils.CommonUtils;

public class DepthRestriction
extends UserLayoutRestriction {
    private Integer[] minDepthArray;
    private Integer[] maxDepthArray;
    private Integer[] depthArray;

    public DepthRestriction(String nodePath) {
        super(nodePath);
    }

    public DepthRestriction() {
    }

    public int getRestrictionType() {
        return 2 | super.getRestrictionType();
    }

    protected void parseRestrictionExpression() throws PortalException {
        try {
            int i;
            String restrictionExp = this.getRestrictionExpression();
            Vector<String> minDepthList = new Vector<String>();
            Vector<String> maxDepthList = new Vector<String>();
            Vector<String> depthList = new Vector<String>();
            StringTokenizer st = new StringTokenizer(restrictionExp, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int index = token.indexOf(45);
                if (index > 0) {
                    minDepthList.add(token.substring(0, index));
                    maxDepthList.add(token.substring(index + 1));
                    continue;
                }
                depthList.add(token);
            }
            int size = minDepthList.size();
            this.minDepthArray = new Integer[size];
            this.maxDepthArray = new Integer[size];
            for (i = 0; i < size; ++i) {
                this.minDepthArray[i] = Integer.valueOf((String)minDepthList.get(i));
                this.maxDepthArray[i] = Integer.valueOf((String)maxDepthList.get(i));
            }
            size = depthList.size();
            this.depthArray = new Integer[size];
            for (i = 0; i < size; ++i) {
                this.depthArray[i] = Integer.valueOf((String)depthList.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PortalException(e.getMessage());
        }
    }

    public boolean checkRestriction(String propertyValue) throws PortalException {
        int depth = CommonUtils.parseInt(propertyValue);
        for (int i = 0; i < this.minDepthArray.length || i < this.depthArray.length; ++i) {
            if (i < this.minDepthArray.length && depth <= this.maxDepthArray[i] && depth >= this.minDepthArray[i]) {
                return true;
            }
            if (i >= this.depthArray.length || this.depthArray[i] != depth) continue;
            return true;
        }
        return false;
    }
}

